package com.xujl.task.group;


import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;

/**
 * 组任务执行策略
 */
public class GroupTaskStrategy {
    /**
     * 默认模式
     * 全部完成模式，全部任务执行完毕后
     * 回调结果
     * 使用此模式，如果组任务配置了失败
     * 重试，则最终回调会等待组任务重试成功
     * 组任务配置了任务重试会阻塞结果回调时机
     */
    public static final int ALL_COMPLETE = 0;
    /**
     * 错误退出模式
     * 一个组任务发生错误则暂停其他任务
     * 并不再继续
     */
    public static final int ERROR_EXIT = 1;
    /**
     * 错误忽略模式
     * 一个任务发生的错误将会被忽略
     * 其他任务正常执行，并待其他任务执行后
     * 继续后续任务，使用此模式会忽略任务重试功能
     * 组任务配置了任务重试不会阻塞结果回调时机
     */
    public static final int ERROR_IGNORE = 2;
    /**
     * 无策略
     */
    public static final int NONE = -1;

    @IntDef(value = {ALL_COMPLETE, ERROR_EXIT, ERROR_IGNORE})
    @Retention(RetentionPolicy.SOURCE)
    public @interface Enum {

    }

    @IntDef(value = {NONE, ERROR_EXIT, ERROR_IGNORE})
    @Retention(RetentionPolicy.SOURCE)
    public @interface Enum2 {

    }
}
