package com.xujl.task.group;


import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;

/**
 * 组任务状态
 */
public class GroupTaskState {
    /**
     * 默认状态
     */
    public static final int STATE_DEFAULT = 0;
    /**
     * 任务已执行完毕，尚未回调状态
     */
    public static final int STATE_EXECUTE = 1;
    /**
     * 任务已执行完毕，且已回调状态
     */
    public static final int STATE_COMPLETE = 2;
    /**
     * 任务执行失败状态
     */
    public static final int STATE_FAILED = 3;

    @IntDef(value = {STATE_DEFAULT, STATE_EXECUTE, STATE_COMPLETE, STATE_FAILED})
    @Retention(RetentionPolicy.SOURCE)
    public @interface Enum {

    }
}
