package com.xujl.task.group;

import java.util.HashMap;
import java.util.Map;

/**
 * 组任务配置
 */
public class GroupTaskBuilder {
    private Map<TaskConfig, GroupTask> mGroupTasks = new HashMap<>();
    private GroupResultTask mResultTask;
    @GroupTaskStrategy.Enum
    private int mGroupStrategy = GroupTaskStrategy.ALL_COMPLETE;

    private GroupTaskBuilder () {
    }

    public static GroupTaskBuilder create () {
        return new GroupTaskBuilder();
    }

    public GroupTaskBuilder setResultTask (GroupResultTask resultTask) {
        mResultTask = resultTask;
        mResultTask.setBuilder(this);
        return this;
    }

    public <T> TaskConfig addGroupTask (GroupTask<T> task) {
        final TaskConfig config = new TaskConfig(this);
        mGroupTasks.put(config, task);
        return config;
    }

    public GroupTaskBuilder setGroupStrategy (@GroupTaskStrategy.Enum int groupStrategy) {
        mGroupStrategy = groupStrategy;
        return this;
    }

    public Map<TaskConfig, GroupTask> getGroupTasks () {
        return mGroupTasks;
    }

    public GroupResultTask getResultTask () {
        return mResultTask;
    }

    public int getGroupStrategy () {
        return mGroupStrategy;
    }
}
