package com.xujl.task.group;

import com.xujl.task.Task;
import com.xujl.task.consts.TaskType;
import com.xujl.task.delegate.GroupTaskDelegate;

/**
 * 组任务
 *
 * @param <T>
 */
public abstract class GroupTask<T> extends Task<T> {

    public GroupTask (boolean needCancel) {
        super(needCancel, TaskType.TYPE_GROUP);
    }

    public GroupTask () {
        super(false, TaskType.TYPE_GROUP);
    }

    @Override
    public void onNext (T data) {
        super.onNext(data);
        ((GroupTaskDelegate) getDelegate()).getGroupConfig().setResultData(data);
    }

    @Override
    public void onObjNext (int code, Object obj) {
        super.onObjNext(code, obj);
        ((GroupTaskDelegate) getDelegate()).getGroupConfig().setResultData(obj);
    }
}
