package com.xujl.task.delegate;

import com.xujl.task.Task;
import com.xujl.task.group.GroupTaskState;
import com.xujl.task.group.TaskConfig;

/**
 * 组任务代理
 *
 * @param <T>
 */
public class GroupTaskDelegate<T> extends AbstractTaskDelegate<T> {
    private TaskConfig mGroupConfig;
    private Object mLock;

    public GroupTaskDelegate (Task<T> task, boolean needCancel) {
        super(task, needCancel);
    }

    @Override
    public void onError (Exception e) {
        super.onError(e);
        mGroupConfig.setState(GroupTaskState.STATE_FAILED);
        synchronized (mLock) {
            mLock.notify();
        }
    }

    @Override
    public void onFinished () {
        super.onFinished();
        mGroupConfig.setState(GroupTaskState.STATE_EXECUTE);
        synchronized (mLock) {
            mLock.notify();
        }
    }

    public void setGroupConfig (TaskConfig groupConfig) {
        mGroupConfig = groupConfig;
    }

    public void setLock (Object lock) {
        mLock = lock;
    }

    public TaskConfig getGroupConfig () {
        return mGroupConfig;
    }
}
