package com.xujl.task;

import com.xujl.task.consts.TaskRetry;
import com.xujl.task.consts.TaskType;

/**
 * @author x
 * @Description
 */
public class TaskBuilder {
    /**
     * 重试次数
     */
    private int retryMaxCount = TaskRetry.NONE;
    /**
     * 任务是否需要取消
     */
    private boolean needCancel;
    /**
     * 任务类型
     */
    @TaskType.Enum
    private int mTaskType = TaskType.TYPE_NORMAL;

    private TaskBuilder () {
    }

    public static TaskBuilder create () {
        return new TaskBuilder();
    }

    public int getRetryMaxCount () {
        return retryMaxCount;
    }

    public TaskBuilder setRetryMaxCount (int retryMaxCount) {
        this.retryMaxCount = retryMaxCount;
        return this;
    }

    public boolean isNeedCancel () {
        return needCancel;
    }

    public TaskBuilder setNeedCancel (boolean needCancel) {
        this.needCancel = needCancel;
        return this;
    }

    public int getTaskType () {
        return mTaskType;
    }

    public TaskBuilder setTaskType (int taskType) {
        mTaskType = taskType;
        return this;
    }

    public TaskBuilder build () {
        return this;
    }
}
