/*
 * Decompiled with CFR 0.152.
 */
package com.xujl.task;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.xujl.task.Logger;
import com.xujl.task.RxMessage;
import com.xujl.task.Task;

class RxHandler
extends Handler {
    private static final String TAG = "RxHandler";

    static RxHandler getInstance() {
        return Holder.RX_HANDLER;
    }

    private RxHandler() {
        super(Looper.getMainLooper());
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        Object obj = msg.obj;
        if (obj == null || !(obj instanceof RxMessage)) {
            Logger.d(TAG, "Task:  Message isNot Task");
            return;
        }
        RxMessage rxMessage = (RxMessage)obj;
        Task task = rxMessage.getTask();
        if (task == null) {
            Logger.d(TAG, "Task:  task.isDestroy");
            return;
        }
        long taskId = task.getTaskId();
        try {
            switch (msg.what) {
                case -1: {
                    Exception exception = (Exception)rxMessage.getObj();
                    Logger.d(TAG, "Task--" + taskId + ":Emitter.ERROR:" + exception.getMessage());
                    task.onError(exception);
                    break;
                }
                case 0: {
                    if (rxMessage.getObj() != null) {
                        Logger.d(TAG, "Task--" + taskId + ":Emitter.ObjNEXT");
                        task.onObjNext(rxMessage.getObjCode(), rxMessage.getObj());
                        break;
                    }
                    Logger.d(TAG, "Task--" + taskId + ":Emitter.NEXT");
                    task.onNext(rxMessage.getData());
                    break;
                }
                case 2: {
                    Logger.d(TAG, "Task--" + taskId + ":Emitter.UI");
                    task.onlyRunUiTask();
                    break;
                }
                case 1: {
                    Logger.d(TAG, "Task--" + taskId + ":Emitter.FINISH");
                    task.onFinished();
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.e(TAG, "RxTask\u4e25\u91cd\u9519\u8bef\uff1a" + e);
        }
    }

    private static class Holder {
        private static final RxHandler RX_HANDLER = new RxHandler();

        private Holder() {
        }
    }
}

