package com.xujl.task;


import android.os.Message;

/**
 * 事件发射器
 */
public class Emitter<T> {
    private static final String TAG = "Emitter";
    public static final int ERROR = -1;
    public static final int NEXT = 0;
    public static final int FINISH = 1;
    public static final int UI = 2;
    private Task<T> task;

    Emitter (Task<T> task) {
        super();
        this.task = task;
    }

    private void sendMessage (int code, T data) {
        Message message = new Message();
        message.what = code;
        message.obj = new RxMessage<>(task, data);
        RxHandler.getInstance().sendMessage(message);
    }

    private void sendObj (int code, Object obj, int objCode) {
        Message message = new Message();
        message.what = code;
        message.obj = new RxMessage<>(task).setObj(obj).setObjCode(objCode);
        RxHandler.getInstance().sendMessage(message);
    }

    private void sendObj (int code, Object obj) {
        sendObj(code, obj, 0);
    }

    public void error (Exception e) {
        sendObj(ERROR, e);
    }

    public void next (T data) {
        sendMessage(NEXT, data);
    }

    public void objNext (Object obj, int objCode) {
        sendObj(NEXT, obj, objCode);
    }

    public void objNext (Object obj) {
        sendObj(NEXT, obj);
    }

    public void finish () {
        sendObj(FINISH, null);
    }

    void runUi () {
        sendObj(UI, null);
    }


}
