/*
 * Decompiled with CFR 0.152.
 */
package com.xujl.task;

import com.xujl.task.Emitter;
import com.xujl.task.IFinishNotify;
import com.xujl.task.ITaskFinish;
import com.xujl.task.RxLife;
import java.util.concurrent.Future;

public abstract class Task<T>
implements RxLife {
    private static final String TAG = "Task";
    private Emitter mEmitter = new Emitter(this);
    private Future<T> mFuture;
    private boolean isDestroy;
    private ITaskFinish mITaskFinish;
    private IFinishNotify mFinishNotify;
    private long taskId;
    private boolean needCancel;

    public Task() {
        this(false);
    }

    public Task(boolean needCancel) {
        this.bindLife(this);
        this.needCancel = needCancel;
        this.taskId = System.currentTimeMillis();
    }

    public void run(Emitter emitter) throws Exception {
    }

    @Override
    public void onDestroy() {
        if (this.mFinishNotify != null) {
            this.mFinishNotify.onDestroy(this);
        }
        if (this.mEmitter == null) {
            return;
        }
        if (this.mFuture != null && this.needCancel) {
            this.mFuture.cancel(true);
        }
        this.mEmitter.error(new Exception("\u751f\u547d\u5468\u671f\u7ed3\u675f\uff0c\u4e2d\u65ad\u5173\u8054\uff01"));
        this.recycle();
    }

    private void recycle() {
        this.isDestroy = true;
        this.mEmitter = null;
    }

    @Override
    public boolean isDestroy() {
        return this.isDestroy;
    }

    public void onlyRunUiTask() {
    }

    public void bindLife(RxLife rxLife) {
    }

    public void onNext(Object object) {
    }

    public void onError(Exception e) {
        if (this.mITaskFinish != null) {
            this.mITaskFinish.onFinish(this);
        }
    }

    public void onFinished() {
        if (this.mITaskFinish != null) {
            this.mITaskFinish.onFinish(this);
        }
        this.onDestroy();
        this.recycle();
    }

    public boolean cancel(boolean interrupt) {
        this.isDestroy = true;
        if (this.mFuture == null) {
            return false;
        }
        return this.mFuture.cancel(interrupt);
    }

    public void reset() {
        this.mEmitter = new Emitter(this);
        this.bindLife(this);
        this.isDestroy = false;
    }

    public Future<T> getFuture() {
        return this.mFuture;
    }

    public void setFuture(Future<T> future) {
        this.mFuture = future;
    }

    public boolean isNeedCancel() {
        return this.needCancel;
    }

    public void setNeedCancel(boolean needCancel) {
        this.needCancel = needCancel;
    }

    @Override
    public final void setITaskFinish(ITaskFinish iTaskFinish) {
        this.mITaskFinish = iTaskFinish;
    }

    Emitter getEmitter() {
        return this.mEmitter;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public long getTaskId() {
        return this.taskId;
    }

    void setFinishNotify(IFinishNotify finishNotify) {
        this.mFinishNotify = finishNotify;
    }
}

