package com.xujl.task;

import java.util.concurrent.Future;

public abstract class Task<T> implements RxLife {
    private static final String TAG = "Task";
    private Emitter mEmitter;
    private Future<T> mFuture;
    private boolean isDestroy;
    private ITaskFinish mITaskFinish;
    private IFinishNotify mFinishNotify;
    /**
     * 任务编号
     */
    private long taskId;
    /**
     * 绑定生命周期时是否需要在
     * 生命周期结束后取消任务
     * 设置为true时（任务可能执行到一半就会结束
     * ，慎重设置！）
     */
    private boolean needCancel;

    public Task () {
        this(false);
    }

    public Task (boolean needCancel) {
        mEmitter = new Emitter(this);
        bindLife(this);
        this.needCancel = needCancel;
        taskId = System.currentTimeMillis();
    }

    public void run (Emitter emitter) throws Exception {
    }

    /**
     * 生命周期结束后，子线程任务依然会执行
     * 完毕，但不会再回调结果,如果需要及时停止
     * 子线程任务，请在子线程任务中根据方法isDestroy()
     * 加以判断
     */
    @Override
    public void onDestroy () {
        if (mFinishNotify != null) {
            mFinishNotify.onDestroy(this);
        }
        if (mEmitter == null) {
            return;
        }
        if (mFuture != null && needCancel) {
            mFuture.cancel(true);
        }
        mEmitter.error(new Exception("生命周期结束，中断关联！"));
        recycle();
    }

    private void recycle () {
        isDestroy = true;
        mEmitter = null;
    }

    @Override
    public boolean isDestroy () {
        return isDestroy;
    }

    /**
     * 仅仅执行ui任务，
     * 主线程回调
     */
    public void onlyRunUiTask () {

    }

    /**
     * 当前线程回调，取决于开启任务的线程
     *
     * @param rxLife
     */
    public void bindLife (RxLife rxLife) {

    }

    /**
     * 主线程回调
     *
     * @param object
     */
    public void onNext (Object object) {

    }

    /**
     * 主线程回调
     *
     * @param e
     */
    public void onError (Exception e) {
        if (mITaskFinish != null) {
            mITaskFinish.onFinish(this);
        }
    }

    /**
     * 主线程回调
     */
    public void onFinished () {
        if (mITaskFinish != null) {
            mITaskFinish.onFinish(this);
        }
        onDestroy();
        recycle();
    }

    /**
     * 取消任务
     * 只能是停掉线程中有sleep,wait,join逻辑的线程，抛出一个InterruptException
     *
     * @param interrupt
     * @return
     */
    public boolean cancel (boolean interrupt) {
        isDestroy = true;
        if (mFuture == null) {
            return false;
        }
        return mFuture.cancel(interrupt);
    }

    public void reset () {
        mEmitter = new Emitter(this);
        bindLife(this);
        isDestroy = false;
    }

    public Future<T> getFuture () {
        return mFuture;
    }

    public void setFuture (Future<T> future) {
        mFuture = future;
    }

    public boolean isNeedCancel () {
        return needCancel;
    }

    public void setNeedCancel (boolean needCancel) {
        this.needCancel = needCancel;
    }

    @Override
    final public void setITaskFinish (ITaskFinish iTaskFinish) {
        mITaskFinish = iTaskFinish;
    }

    Emitter getEmitter () {
        return mEmitter;
    }

    @Override
    public boolean equals (Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode () {
        return super.hashCode();
    }

    public long getTaskId () {
        return taskId;
    }

    void setFinishNotify (IFinishNotify finishNotify) {
        mFinishNotify = finishNotify;
    }
}
