package com.xujl.task;

import java.util.concurrent.Callable;

/**
 * <pre>
 *     @author : xujl
 *     e-mail : 597355068@qq.com
 *     time   : 2018/7/24
 *     desc   :
 *     version: 1.0
 * </pre>
 */
public class TaskCallable<T> implements Callable<T> {
    protected static final String TAG = "TaskThread";
    private Task task;

    public TaskCallable (Task task) {
        this.task = task;
    }

    public TaskCallable () {
    }

    public void setTask (Task task) {
        this.task = task;
    }

    @Override
    final public T call () throws Exception {
        Logger.d(TAG, "threadId:" + Thread.currentThread().getId() + "&&taskId:" + task.getTaskId());
        if (isTaskNull()) {
            Logger.e(TAG, "call:task==null");
            return null;
        }
        try {
            /*优先执行当前子类run(emitter)方法，如果
            当前方法返回false则再去执行Task的run方法
             */
            final boolean isFinish = run(task.getEmitter());
            if (!isFinish) {
                task.run(task.getEmitter());
            }
        } catch (Exception e) {
            Logger.e(TAG, "任务执行出错：", e);
            if (isEmitterNotNull()) {
                task.getEmitter().error(e);
            }
        }
        if (isEmitterNotNull()) {
            task.getEmitter().finish();
        }
        return null;
    }

    /**
     * 发射器是否不为空
     *
     * @return
     */
    private boolean isEmitterNotNull () {
        return task != null && task.getEmitter() != null;
    }

    /**
     * 任务是否存在
     *
     * @return
     */
    private boolean isTaskNull () {
        return this.task == null;
    }

    /**
     * 子线程方法
     *
     * @param emitter
     * @return
     * @throws Exception
     */
    public boolean run (Emitter emitter) throws Exception {
        return false;
    }


}
