package com.xujl.task;


import android.os.Message;

/**
 * 事件发射器
 */
public class Emitter {
    private static final String TAG = "Emitter";
    public static final int ERROR = -1;
    public static final int NEXT = 0;
    public static final int FINISH = 1;
    public static final int UI = 2;
    private Task task;

    Emitter (Task task) {
        super();
        this.task = task;
    }

    private void sendMessage (int code, Object object) {
        Message message = new Message();
        message.what = code;
        message.obj = new RxMessage(task, object);
        RxHandler.getInstance().sendMessage(message);
    }

    public void error (Exception e) {
        sendMessage(ERROR, e);
    }

    public void next (Object object) {
        sendMessage(NEXT, object);
    }

    public void finish () {
        sendMessage(FINISH, null);
    }

    void runUi () {
        sendMessage(UI, null);
    }


}
