/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.treewalk.filter;

import com.xenoterracide.gradle.semver.jgit.annotations.Nullable;
import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.TreeWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.NotTreeFilter;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;

public abstract class TreeFilter {
    public static final TreeFilter ALL = new AllFilter();
    public static final TreeFilter ANY_DIFF = new AnyDiffFilter();

    public TreeFilter negate() {
        return NotTreeFilter.create(this);
    }

    public abstract boolean include(TreeWalk var1) throws MissingObjectException, IncorrectObjectTypeException, IOException;

    public int matchFilter(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.include(walker) ? 0 : 1;
    }

    public abstract boolean shouldBeRecursive();

    public boolean shouldTreeWalk(RevCommit c, RevWalk rw, @Nullable MutableBoolean cpfUsed) {
        return true;
    }

    @Deprecated(since="7.3")
    public Optional<Set<byte[]>> getPathsBestEffort() {
        return Optional.empty();
    }

    public abstract TreeFilter clone();

    public String toString() {
        String n = this.getClass().getName();
        int lastDot = n.lastIndexOf(46);
        if (lastDot >= 0) {
            n = n.substring(lastDot + 1);
        }
        return n.replace('$', '.');
    }

    private static final class AllFilter
    extends TreeFilter {
        private AllFilter() {
        }

        @Override
        public boolean include(TreeWalk walker) {
            return true;
        }

        @Override
        public boolean shouldBeRecursive() {
            return false;
        }

        @Override
        public TreeFilter clone() {
            return this;
        }

        @Override
        public String toString() {
            return "ALL";
        }
    }

    private static final class AnyDiffFilter
    extends TreeFilter {
        private static final int baseTree = 0;

        private AnyDiffFilter() {
        }

        @Override
        public boolean include(TreeWalk walker) {
            int n = walker.getTreeCount();
            if (n == 1) {
                return true;
            }
            int m = walker.getRawMode(0);
            int i = 1;
            while (i < n) {
                if (walker.getRawMode(i) != m || !walker.idEqual(i, 0)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean shouldBeRecursive() {
            return false;
        }

        @Override
        public TreeFilter clone() {
            return this;
        }

        @Override
        public String toString() {
            return "ANY_DIFF";
        }
    }

    public static class MutableBoolean {
        private boolean value;

        public boolean get() {
            return this.value;
        }

        void orValue(boolean v) {
            this.value = this.value || v;
        }

        public void reset() {
            this.value = false;
        }
    }
}

