/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.treewalk.filter;

import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.TreeWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

public abstract class OrTreeFilter
extends TreeFilter {
    public static TreeFilter create(TreeFilter a, TreeFilter b) {
        if (a == ALL || b == ALL) {
            return ALL;
        }
        return new Binary(a, b);
    }

    public static TreeFilter create(TreeFilter[] list) {
        if (list.length == 2) {
            return OrTreeFilter.create(list[0], list[1]);
        }
        if (list.length < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list.length];
        System.arraycopy(list, 0, subfilters, 0, list.length);
        return new List(subfilters);
    }

    public static TreeFilter create(Collection<TreeFilter> list) {
        if (list.size() < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list.size()];
        list.toArray(subfilters);
        if (subfilters.length == 2) {
            return OrTreeFilter.create(subfilters[0], subfilters[1]);
        }
        return new List(subfilters);
    }

    private static class Binary
    extends OrTreeFilter {
        private final TreeFilter a;
        private final TreeFilter b;

        Binary(TreeFilter one, TreeFilter two) {
            this.a = one;
            this.b = two;
        }

        @Override
        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.matchFilter(walker) <= 0;
        }

        @Override
        public int matchFilter(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            int ra = this.a.matchFilter(walker);
            if (ra == 0) {
                return 0;
            }
            int rb = this.b.matchFilter(walker);
            if (rb == 0) {
                return 0;
            }
            if (ra == -1 || rb == -1) {
                return -1;
            }
            return 1;
        }

        @Override
        public boolean shouldTreeWalk(RevCommit c, RevWalk rw, TreeFilter.MutableBoolean cpfUsed) {
            return this.a.shouldTreeWalk(c, rw, cpfUsed) || this.b.shouldTreeWalk(c, rw, cpfUsed);
        }

        @Override
        public boolean shouldBeRecursive() {
            return this.a.shouldBeRecursive() || this.b.shouldBeRecursive();
        }

        @Override
        public TreeFilter clone() {
            return new Binary(this.a.clone(), this.b.clone());
        }

        @Override
        public String toString() {
            return "(" + this.a.toString() + " OR " + this.b.toString() + ")";
        }
    }

    private static class List
    extends OrTreeFilter {
        private final TreeFilter[] subfilters;

        List(TreeFilter[] list) {
            this.subfilters = list;
        }

        @Override
        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.matchFilter(walker) <= 0;
        }

        @Override
        public int matchFilter(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            int m = 1;
            TreeFilter[] treeFilterArray = this.subfilters;
            int n = this.subfilters.length;
            int n2 = 0;
            while (n2 < n) {
                TreeFilter f = treeFilterArray[n2];
                int r = f.matchFilter(walker);
                if (r == 0) {
                    return 0;
                }
                if (r == -1) {
                    m = -1;
                }
                ++n2;
            }
            return m;
        }

        @Override
        public boolean shouldTreeWalk(RevCommit c, RevWalk rw, TreeFilter.MutableBoolean cpfUsed) {
            return Arrays.stream(this.subfilters).anyMatch(t -> t.shouldTreeWalk(c, rw, cpfUsed));
        }

        @Override
        public boolean shouldBeRecursive() {
            TreeFilter[] treeFilterArray = this.subfilters;
            int n = this.subfilters.length;
            int n2 = 0;
            while (n2 < n) {
                TreeFilter f = treeFilterArray[n2];
                if (f.shouldBeRecursive()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public TreeFilter clone() {
            TreeFilter[] s = new TreeFilter[this.subfilters.length];
            int i = 0;
            while (i < s.length) {
                s[i] = this.subfilters[i].clone();
                ++i;
            }
            return new List(s);
        }

        @Override
        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append("(");
            int i = 0;
            while (i < this.subfilters.length) {
                if (i > 0) {
                    r.append(" OR ");
                }
                r.append(this.subfilters[i].toString());
                ++i;
            }
            r.append(")");
            return r.toString();
        }
    }
}

