/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.transport.http;

import com.xenoterracide.gradle.semver.jgit.annotations.NonNull;
import com.xenoterracide.gradle.semver.jgit.internal.transport.http.DelegatingSSLSocketFactory;
import com.xenoterracide.gradle.semver.jgit.transport.http.HttpConnection;
import com.xenoterracide.gradle.semver.jgit.util.HttpSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;

public class JDKHttpConnection
implements HttpConnection {
    HttpURLConnection wrappedUrlConnection;

    JDKHttpConnection(HttpURLConnection urlConnection) {
        this.wrappedUrlConnection = urlConnection;
    }

    protected JDKHttpConnection(URL url) throws MalformedURLException, IOException {
        this.wrappedUrlConnection = (HttpURLConnection)url.openConnection();
    }

    protected JDKHttpConnection(URL url, Proxy proxy) throws MalformedURLException, IOException {
        this.wrappedUrlConnection = (HttpURLConnection)url.openConnection(proxy);
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.wrappedUrlConnection.getResponseCode();
    }

    @Override
    public URL getURL() {
        return this.wrappedUrlConnection.getURL();
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.wrappedUrlConnection.getResponseMessage();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.wrappedUrlConnection.getHeaderFields();
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.wrappedUrlConnection.setRequestProperty(key, value);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.wrappedUrlConnection.setRequestMethod(method);
    }

    @Override
    public void setUseCaches(boolean usecaches) {
        this.wrappedUrlConnection.setUseCaches(usecaches);
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.wrappedUrlConnection.setConnectTimeout(timeout);
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.wrappedUrlConnection.setReadTimeout(timeout);
    }

    @Override
    public String getContentType() {
        return this.wrappedUrlConnection.getContentType();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.wrappedUrlConnection.getInputStream();
    }

    @Override
    public String getHeaderField(@NonNull String name) {
        return this.wrappedUrlConnection.getHeaderField(name);
    }

    @Override
    public List<String> getHeaderFields(@NonNull String name) {
        Map<String, List<String>> m = this.wrappedUrlConnection.getHeaderFields();
        List<String> fields = JDKHttpConnection.mapValuesToListIgnoreCase(name, m);
        return fields;
    }

    private static List<String> mapValuesToListIgnoreCase(String keyName, Map<String, List<String>> m) {
        ArrayList<String> fields = new ArrayList<String>();
        m.entrySet().stream().filter(e -> keyName.equalsIgnoreCase((String)e.getKey())).filter(e -> e.getValue() != null).forEach(e -> {
            boolean bl = fields.addAll((Collection)e.getValue());
        });
        return fields;
    }

    @Override
    public int getContentLength() {
        return this.wrappedUrlConnection.getContentLength();
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.wrappedUrlConnection.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public void setDoOutput(boolean dooutput) {
        this.wrappedUrlConnection.setDoOutput(dooutput);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.wrappedUrlConnection.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.wrappedUrlConnection.getOutputStream();
    }

    @Override
    public void setChunkedStreamingMode(int chunklen) {
        this.wrappedUrlConnection.setChunkedStreamingMode(chunklen);
    }

    @Override
    public String getRequestMethod() {
        return this.wrappedUrlConnection.getRequestMethod();
    }

    @Override
    public boolean usingProxy() {
        return this.wrappedUrlConnection.usingProxy();
    }

    @Override
    public void connect() throws IOException {
        this.wrappedUrlConnection.connect();
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier hostnameverifier) {
        ((HttpsURLConnection)this.wrappedUrlConnection).setHostnameVerifier(hostnameverifier);
    }

    @Override
    public void configure(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(km, tm, random);
        ((HttpsURLConnection)this.wrappedUrlConnection).setSSLSocketFactory(new DelegatingSSLSocketFactory(ctx.getSocketFactory()){

            @Override
            protected void configure(SSLSocket socket) throws IOException {
                HttpSupport.configureTLS(socket);
            }
        });
    }
}

