/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.storage.file;

import com.xenoterracide.gradle.semver.jgit.errors.ConfigInvalidException;
import com.xenoterracide.gradle.semver.jgit.errors.LockFailedException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.FileSnapshot;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.LockFile;
import com.xenoterracide.gradle.semver.jgit.lib.Config;
import com.xenoterracide.gradle.semver.jgit.lib.Constants;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.StoredConfig;
import com.xenoterracide.gradle.semver.jgit.util.FS;
import com.xenoterracide.gradle.semver.jgit.util.FileUtils;
import com.xenoterracide.gradle.semver.jgit.util.IO;
import com.xenoterracide.gradle.semver.jgit.util.RawParseUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FileBasedConfig
extends StoredConfig {
    private final File configFile;
    private final FS fs;
    private final ReentrantReadWriteLock lock;
    private boolean utf8Bom;
    private volatile FileSnapshot snapshot;
    private volatile ObjectId hash;
    private AtomicBoolean exists = new AtomicBoolean();

    public FileBasedConfig(File cfgLocation, FS fs) {
        this(null, cfgLocation, fs);
    }

    public FileBasedConfig(Config base, File cfgLocation, FS fs) {
        super(base);
        this.configFile = cfgLocation;
        this.fs = fs;
        this.snapshot = FileSnapshot.DIRTY;
        this.hash = ObjectId.zeroId();
        this.lock = new ReentrantReadWriteLock(false);
    }

    @Override
    protected boolean notifyUponTransientChanges() {
        return false;
    }

    public final File getFile() {
        return this.configFile;
    }

    boolean exists() {
        return this.exists.get();
    }

    @Override
    public void load() throws IOException, ConfigInvalidException {
        this.lock.readLock().lock();
        try {
            try {
                Boolean wasRead = FileUtils.readWithRetries(this.getFile(), this::load);
                if (wasRead == null) {
                    this.clear();
                    this.snapshot = FileSnapshot.MISSING_FILE;
                }
                this.exists.set(wasRead != null);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, this.getFile()), e);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Boolean load(File f) throws Exception {
        FileSnapshot oldSnapshot = this.snapshot;
        FileSnapshot newSnapshot = FileSnapshot.saveNoConfig(f);
        byte[] in = IO.readFully(f);
        ObjectId newHash = FileBasedConfig.hash(in);
        if (this.hash.equals(newHash)) {
            if (oldSnapshot.equals(newSnapshot)) {
                oldSnapshot.setClean(newSnapshot);
            } else {
                this.snapshot = newSnapshot;
            }
        } else {
            String decoded;
            if (this.isUtf8(in)) {
                decoded = RawParseUtils.decode(StandardCharsets.UTF_8, in, 3, in.length);
                this.utf8Bom = true;
            } else {
                decoded = RawParseUtils.decode(in);
            }
            this.fromText(decoded);
            this.snapshot = newSnapshot;
            this.hash = newHash;
        }
        return Boolean.TRUE;
    }

    @Override
    public void save() throws IOException {
        this.lock.writeLock().lock();
        try {
            byte[] out;
            String text = this.toText();
            if (this.utf8Bom) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                bos.write(239);
                bos.write(187);
                bos.write(191);
                bos.write(text.getBytes(StandardCharsets.UTF_8));
                out = bos.toByteArray();
            } else {
                out = Constants.encode(text);
            }
            LockFile lf = new LockFile(this.getFile());
            try {
                if (!lf.lock()) {
                    throw new LockFailedException(this.getFile());
                }
                lf.setNeedSnapshotNoConfig(true);
                lf.write(out);
                if (!lf.commit()) {
                    throw new IOException(MessageFormat.format(JGitText.get().cannotCommitWriteTo, this.getFile()));
                }
            }
            finally {
                lf.unlock();
            }
            this.snapshot = lf.getCommitSnapshot();
            this.hash = FileBasedConfig.hash(out);
            this.exists.set(true);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.fireConfigChangedEvent();
    }

    @Override
    public void clear() {
        this.hash = FileBasedConfig.hash(new byte[0]);
        super.clear();
    }

    private static ObjectId hash(byte[] rawText) {
        return ObjectId.fromRaw(Constants.newMessageDigest().digest(rawText));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getFile().getPath() + "]";
    }

    public boolean isOutdated() {
        return this.snapshot.isModified(this.getFile());
    }

    @Override
    protected byte[] readIncludedConfig(String relPath) throws ConfigInvalidException {
        File file = relPath.startsWith("~/") ? this.fs.resolve(this.fs.userHome(), relPath.substring(2)) : this.fs.resolve(this.configFile.getParentFile(), relPath);
        if (!file.exists()) {
            return null;
        }
        try {
            return IO.readFully(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException ioe) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, relPath), ioe);
        }
    }
}

