/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.storage.file;

import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.PackBitmapIndex;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.PackIndex;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.PackReverseIndex;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.PackReverseIndexComputed;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.PackReverseIndexV1;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.SimpleDataInput;
import com.xenoterracide.gradle.semver.jgit.lib.Constants;
import com.xenoterracide.gradle.semver.jgit.util.IO;
import com.xenoterracide.gradle.semver.jgit.util.io.SilentFileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.text.MessageFormat;
import java.util.Arrays;

public final class PackReverseIndexFactory {
    static PackReverseIndex openOrCompute(File idxFile, long objectCount, PackBitmapIndex.SupplierWithIOException<PackIndex> packIndexSupplier) throws IOException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (SilentFileInputStream fd = new SilentFileInputStream(idxFile);){
                return PackReverseIndexFactory.readFromFile(fd, objectCount, packIndexSupplier);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            return PackReverseIndexFactory.computeFromIndex(packIndexSupplier.get());
        }
        catch (IOException e) {
            throw new IOException(MessageFormat.format(JGitText.get().unreadablePackIndex, idxFile.getAbsolutePath()), e);
        }
    }

    public static PackReverseIndex computeFromIndex(PackIndex packIndex) {
        return new PackReverseIndexComputed(packIndex);
    }

    static PackReverseIndex readFromFile(InputStream src, long objectCount, PackBitmapIndex.SupplierWithIOException<PackIndex> packIndexSupplier) throws IOException {
        DigestInputStream digestIn = new DigestInputStream(src, Constants.newMessageDigest());
        byte[] magic = new byte[PackReverseIndex.MAGIC.length];
        IO.readFully(digestIn, magic);
        if (!Arrays.equals(magic, PackReverseIndex.MAGIC)) {
            throw new IOException(MessageFormat.format(JGitText.get().expectedGot, Arrays.toString(PackReverseIndex.MAGIC), Arrays.toString(magic)));
        }
        SimpleDataInput dataIn = new SimpleDataInput(digestIn);
        int version = dataIn.readInt();
        switch (version) {
            case 1: {
                return new PackReverseIndexV1(digestIn, objectCount, packIndexSupplier);
            }
        }
        throw new IOException(MessageFormat.format(JGitText.get().unsupportedPackReverseIndexVersion, String.valueOf(version)));
    }
}

