/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.gitrepo;

import com.xenoterracide.gradle.semver.jgit.annotations.NonNull;
import com.xenoterracide.gradle.semver.jgit.annotations.Nullable;
import com.xenoterracide.gradle.semver.jgit.api.Git;
import com.xenoterracide.gradle.semver.jgit.api.GitCommand;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.InvalidRefNameException;
import com.xenoterracide.gradle.semver.jgit.gitrepo.BareSuperprojectWriter;
import com.xenoterracide.gradle.semver.jgit.gitrepo.ManifestParser;
import com.xenoterracide.gradle.semver.jgit.gitrepo.RegularSuperprojectWriter;
import com.xenoterracide.gradle.semver.jgit.gitrepo.RepoProject;
import com.xenoterracide.gradle.semver.jgit.gitrepo.internal.RepoText;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.lib.FileMode;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.PersonIdent;
import com.xenoterracide.gradle.semver.jgit.lib.ProgressMonitor;
import com.xenoterracide.gradle.semver.jgit.lib.Ref;
import com.xenoterracide.gradle.semver.jgit.lib.RefDatabase;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.treewalk.TreeWalk;
import com.xenoterracide.gradle.semver.jgit.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.TreeMap;

public class RepoCommand
extends GitCommand<RevCommit> {
    private String manifestPath;
    private String baseUri;
    private URI targetUri;
    private String groupsParam;
    private String branch;
    private String targetBranch = "HEAD";
    private PersonIdent author;
    private RemoteReader callback;
    private InputStream inputStream;
    private ManifestParser.IncludedFileReader includedReader;
    private BareSuperprojectWriter.BareWriterConfig bareWriterConfig = BareSuperprojectWriter.BareWriterConfig.getDefault();
    private ProgressMonitor monitor;
    private final List<BareSuperprojectWriter.ExtraContent> extraContents = new ArrayList<BareSuperprojectWriter.ExtraContent>();
    private static final String SLASH = "/";

    public RepoCommand(Repository repo) {
        super(repo);
    }

    public RepoCommand setPath(String path) {
        this.manifestPath = path;
        return this;
    }

    public RepoCommand setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public RepoCommand setURI(String uri) {
        this.baseUri = uri;
        return this;
    }

    public RepoCommand setTargetURI(String uri) {
        this.targetUri = URI.create(uri + SLASH);
        return this;
    }

    public RepoCommand setGroups(String groups) {
        this.groupsParam = groups;
        return this;
    }

    public RepoCommand setBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public RepoCommand setTargetBranch(String branch) {
        this.targetBranch = "refs/heads/" + branch;
        return this;
    }

    public RepoCommand setRecordRemoteBranch(boolean enable) {
        this.bareWriterConfig.recordRemoteBranch = enable;
        return this;
    }

    public RepoCommand setRecordSubmoduleLabels(boolean enable) {
        this.bareWriterConfig.recordSubmoduleLabels = enable;
        return this;
    }

    public RepoCommand setRecommendShallow(boolean enable) {
        this.bareWriterConfig.recordShallowSubmodules = enable;
        return this;
    }

    public RepoCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public RepoCommand setIgnoreRemoteFailures(boolean ignore) {
        this.bareWriterConfig.ignoreRemoteFailures = ignore;
        return this;
    }

    public RepoCommand setAuthor(PersonIdent author) {
        this.author = author;
        return this;
    }

    public RepoCommand setRemoteReader(RemoteReader callback) {
        this.callback = callback;
        return this;
    }

    public RepoCommand setIncludedFileReader(ManifestParser.IncludedFileReader reader) {
        this.includedReader = reader;
        return this;
    }

    public RepoCommand addToDestination(String path, String contents) {
        this.extraContents.add(new BareSuperprojectWriter.ExtraContent(path, contents));
        return this;
    }

    @Override
    public RevCommit call() throws GitAPIException {
        List<RepoProject> filteredProjects;
        this.checkCallable();
        if (this.baseUri == null) {
            this.baseUri = "";
        }
        if (this.inputStream == null) {
            if (this.manifestPath == null || this.manifestPath.length() == 0) {
                throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
            }
            try {
                this.inputStream = new FileInputStream(this.manifestPath);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(JGitText.get().pathNotConfigured, e);
            }
        }
        try {
            try {
                ManifestParser parser = new ManifestParser(this.includedReader, this.manifestPath, this.branch, this.baseUri, this.groupsParam, this.repo);
                parser.read(this.inputStream);
                filteredProjects = parser.getFilteredProjects();
            }
            catch (IOException e) {
                throw new ManifestErrorException(e);
            }
        }
        finally {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.repo.isBare()) {
            List<RepoProject> renamedProjects = this.renameProjects(filteredProjects);
            BareSuperprojectWriter writer = new BareSuperprojectWriter(this.repo, this.targetUri, this.targetBranch, this.author == null ? new PersonIdent(this.repo) : this.author, this.callback == null ? new DefaultRemoteReader() : this.callback, this.bareWriterConfig, this.extraContents);
            return writer.write(renamedProjects);
        }
        RegularSuperprojectWriter writer = new RegularSuperprojectWriter(this.repo, this.monitor);
        return writer.write(filteredProjects);
    }

    private List<RepoProject> renameProjects(List<RepoProject> projects) {
        TreeMap<String, ArrayList<RepoProject>> m = new TreeMap<String, ArrayList<RepoProject>>();
        for (RepoProject proj : projects) {
            ArrayList<RepoProject> l = (ArrayList<RepoProject>)m.get(proj.getName());
            if (l == null) {
                l = new ArrayList<RepoProject>();
                m.put(proj.getName(), l);
            }
            l.add(proj);
        }
        ArrayList<RepoProject> ret = new ArrayList<RepoProject>();
        for (List ps : m.values()) {
            boolean nameConflict = ps.size() != 1;
            for (RepoProject proj : ps) {
                Object name = proj.getName();
                if (nameConflict) {
                    name = (String)name + SLASH + proj.getPath();
                }
                RepoProject p = new RepoProject((String)name, proj.getPath(), proj.getRevision(), null, proj.getGroups(), proj.getRecommendShallow());
                p.setUrl(proj.getUrl());
                p.addCopyFiles(proj.getCopyFiles());
                p.addLinkFiles(proj.getLinkFiles());
                p.setUpstream(proj.getUpstream());
                ret.add(p);
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    static URI relativize(URI current, URI target) {
        if (!Objects.equals(current.getHost(), target.getHost())) {
            return target;
        }
        cur = current.normalize().getPath();
        dest = target.normalize().getPath();
        if (cur.startsWith("/") == dest.startsWith("/")) ** GOTO lbl8
        return target;
lbl-1000:
        // 1 sources

        {
            cur = cur.substring(1);
lbl8:
            // 2 sources

            ** while (cur.startsWith((String)"/"))
        }
lbl9:
        // 2 sources

        while (dest.startsWith("/")) {
            dest = dest.substring(1);
        }
        if (cur.indexOf(47) == -1 || dest.indexOf(47) == -1) {
            prefix = "prefix/";
            cur = prefix + (String)cur;
            dest = prefix + (String)dest;
        }
        if (!cur.endsWith("/")) {
            lastSlash = cur.lastIndexOf(47);
            cur = cur.substring(0, lastSlash);
        }
        destFile = "";
        if (!dest.endsWith("/")) {
            lastSlash = dest.lastIndexOf(47);
            destFile = dest.substring(lastSlash + 1, dest.length());
            dest = dest.substring(0, dest.lastIndexOf(47));
        }
        cs = cur.split("/");
        ds = dest.split("/");
        common = 0;
        while (common < cs.length && common < ds.length && cs[common].equals(ds[common])) {
            ++common;
        }
        j = new StringJoiner("/");
        i = common;
        while (i < cs.length) {
            j.add("..");
            ++i;
        }
        i = common;
        while (i < ds.length) {
            j.add(ds[i]);
            ++i;
        }
        j.add(destFile);
        return URI.create(j.toString());
    }

    public static class DefaultRemoteReader
    implements RemoteReader {
        @Override
        public ObjectId sha1(String uri, String ref) throws GitAPIException {
            Map<String, Ref> map = Git.lsRemoteRepository().setRemote(uri).callAsMap();
            Ref r = RefDatabase.findRef(map, ref);
            return r != null ? r.getObjectId() : null;
        }

        @Override
        public RemoteFile readFileWithMode(String uri, String ref, String path) throws GitAPIException, IOException {
            File dir = FileUtils.createTempDir("jgit_", ".git", null);
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                Git git = Git.cloneRepository().setBare(true).setDirectory(dir).setURI(uri).call();
                try {
                    Repository repo = git.getRepository();
                    ObjectId refCommitId = this.sha1(uri, ref);
                    if (refCommitId == null) {
                        throw new InvalidRefNameException(MessageFormat.format(JGitText.get().refNotResolved, ref));
                    }
                    RevCommit commit = repo.parseCommit(refCommitId);
                    TreeWalk tw = TreeWalk.forPath(repo, path, commit.getTree());
                    RemoteFile remoteFile = new RemoteFile(tw.getObjectReader().open(tw.getObjectId(0)).getCachedBytes(Integer.MAX_VALUE), tw.getFileMode(0));
                    if (git != null) {
                        git.close();
                    }
                    return remoteFile;
                }
                catch (Throwable throwable2) {
                    try {
                        if (git != null) {
                            git.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
            }
            finally {
                FileUtils.delete(dir, 1);
            }
        }
    }

    static class ManifestErrorException
    extends GitAPIException {
        ManifestErrorException(Throwable cause) {
            super(RepoText.get().invalidManifest + " " + cause.getMessage(), cause);
        }
    }

    public static final class RemoteFile {
        @NonNull
        private final byte[] contents;
        @NonNull
        private final FileMode fileMode;

        public RemoteFile(@NonNull byte[] contents, @NonNull FileMode fileMode) {
            this.contents = Objects.requireNonNull(contents);
            this.fileMode = Objects.requireNonNull(fileMode);
        }

        @NonNull
        public byte[] getContents() {
            return this.contents;
        }

        @NonNull
        public FileMode getFileMode() {
            return this.fileMode;
        }
    }

    public static interface RemoteReader {
        @Nullable
        public ObjectId sha1(String var1, String var2) throws GitAPIException;

        @NonNull
        public RemoteFile readFileWithMode(String var1, String var2, String var3) throws GitAPIException, IOException;
    }

    static class RemoteUnavailableException
    extends GitAPIException {
        RemoteUnavailableException(String uri) {
            super(MessageFormat.format(RepoText.get().errorRemoteUnavailable, uri));
        }
    }
}

