/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.git;

import com.xenoterracide.gradle.git.DistanceCalculator;
import com.xenoterracide.gradle.git.GitMetadata;
import com.xenoterracide.gradle.git.GitMetadataImpl;
import com.xenoterracide.gradle.git.GitRemote;
import com.xenoterracide.gradle.git.GitRemoteForGradle;
import com.xenoterracide.gradle.git.GitService;
import com.xenoterracide.gradle.git.GitStatus;
import com.xenoterracide.gradle.git.MergeBaseFinder;
import com.xenoterracide.gradle.git.ProvidedFactory;
import com.xenoterracide.gradle.git.Provides;
import com.xenoterracide.gradle.semver.jgit.api.Git;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.Incubating;
import org.gradle.api.provider.Provider;

public class GitExtension
implements Provides<GitMetadata> {
    private final Provider<GitMetadata> provider;
    private final Provider<String> uniqueShort;
    private final Provider<String> tag;
    private final Provider<Long> distance;
    private final Provider<GitStatus> status;
    private final Provider<String> branch;
    private final Provider<String> commit;
    private final Provider<List<GitRemoteForGradle>> remotes;
    private final Provider<Git> git;

    GitExtension(Provider<GitService> gitService, ProvidedFactory pf) {
        this.git = gitService.flatMap(GitService::getProvider);
        this.provider = gitService.map(GitService::getProvider).map(git -> new GitMetadataImpl(() -> ((Provider)git).getOrNull()));
        this.branch = pf.providedString((Provider<String>)this.provider.map(GitMetadata::branch));
        this.uniqueShort = pf.providedString((Provider<String>)this.provider.map(GitMetadata::uniqueShort));
        this.tag = pf.providedString((Provider<String>)this.provider.map(GitMetadata::tag));
        this.distance = pf.providedLong((Provider<Long>)this.provider.map(GitMetadata::distance));
        this.status = pf.provided(this.provider.map(GitMetadata::status), GitStatus.class);
        this.commit = pf.providedString((Provider<String>)this.provider.map(GitMetadata::commit));
        this.remotes = pf.providedList(this.provider.map(GitMetadata::remotes).map(remotes -> remotes.stream().map(remote -> new GitRemoteForGradle(pf, (GitRemote)remote)).collect(Collectors.toList())), GitRemoteForGradle.class);
    }

    @Override
    public Provider<GitMetadata> getProvider() {
        return this.provider;
    }

    public Provider<String> getBranch() {
        return this.branch;
    }

    public Provider<String> getUniqueShort() {
        return this.uniqueShort;
    }

    public Provider<String> getTag() {
        return this.tag;
    }

    public Provider<Long> getDistance() {
        return this.distance;
    }

    public Provider<Boolean> getDirty() {
        return this.status.map(GitStatus.DIRTY::equals);
    }

    public Provider<GitStatus> getStatus() {
        return this.status.orElse((Object)GitStatus.NO_REPO);
    }

    public Provider<String> getCommit() {
        return this.commit;
    }

    @Incubating
    public Provider<List<GitRemoteForGradle>> getRemotes() {
        return this.remotes;
    }

    public Optional<Long> commonAncestorDistanceFor(GitRemoteForGradle remote) {
        Optional<ObjectId> oObjectId = new MergeBaseFinder(((Git)this.git.get()).getRepository()).find(remote);
        return oObjectId.map(oid -> new DistanceCalculator(() -> this.git.get()).apply(oid.getName()));
    }
}

