/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.html.HtmlTextArea;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLFormElement;
import org.htmlunit.javascript.host.html.LabelsNodeList;
import org.htmlunit.javascript.host.html.ValidityState;

@JsxClass(domClass=HtmlTextArea.class)
public class HTMLTextAreaElement
extends HTMLElement {
    private NodeList labels_;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public String getType() {
        return "textarea";
    }

    @Override
    public HtmlTextArea getDomNodeOrDie() {
        return (HtmlTextArea)super.getDomNodeOrDie();
    }

    @Override
    @JsxGetter
    public String getValue() {
        return this.getDomNodeOrDie().getText();
    }

    @Override
    @JsxSetter
    public void setValue(Object value) {
        if (null == value) {
            this.getDomNodeOrDie().setText("");
            return;
        }
        this.getDomNodeOrDie().setText(JavaScriptEngine.toString(value));
    }

    @JsxGetter
    public int getCols() {
        String s = this.getDomNodeOrDie().getAttributeDirect("cols");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 20;
        }
    }

    @JsxSetter
    public void setCols(String cols) {
        try {
            int i = Float.valueOf(cols).intValue();
            if (i < 0) {
                this.getDomNodeOrDie().setAttribute("cols", null);
                return;
            }
            this.getDomNodeOrDie().setAttribute("cols", Integer.toString(i));
        }
        catch (NumberFormatException e) {
            this.getDomNodeOrDie().setAttribute("cols", "20");
        }
    }

    @JsxGetter
    public int getRows() {
        String s = this.getDomNodeOrDie().getAttributeDirect("rows");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 2;
        }
    }

    @JsxSetter
    public void setRows(String rows) {
        try {
            int i = Float.valueOf(rows).intValue();
            if (i < 0) {
                this.getDomNodeOrDie().setAttribute("rows", null);
                return;
            }
            this.getDomNodeOrDie().setAttribute("rows", Integer.toString(i));
        }
        catch (NumberFormatException e) {
            this.getDomNodeOrDie().setAttribute("rows", "2");
        }
    }

    @JsxGetter
    public String getDefaultValue() {
        return this.getDomNodeOrDie().getDefaultValue();
    }

    @JsxSetter
    public void setDefaultValue(String defaultValue) {
        this.getDomNodeOrDie().setDefaultValue(defaultValue);
    }

    @JsxGetter
    public int getTextLength() {
        return this.getValue().length();
    }

    @JsxGetter
    public int getSelectionStart() {
        return this.getDomNodeOrDie().getSelectionStart();
    }

    @JsxSetter
    public void setSelectionStart(int start) {
        this.getDomNodeOrDie().setSelectionStart(start);
    }

    @JsxGetter
    public int getSelectionEnd() {
        return this.getDomNodeOrDie().getSelectionEnd();
    }

    @JsxSetter
    public void setSelectionEnd(int end) {
        this.getDomNodeOrDie().setSelectionEnd(end);
    }

    @JsxFunction
    public void setSelectionRange(int start, int end) {
        this.setSelectionStart(start);
        this.setSelectionEnd(end);
    }

    @JsxFunction
    public void select() {
        this.getDomNodeOrDie().select();
    }

    @JsxGetter
    public boolean isReadOnly() {
        return this.getDomNodeOrDie().isReadOnly();
    }

    @JsxSetter
    public void setReadOnly(boolean readOnly) {
        this.getDomNodeOrDie().setReadOnly(readOnly);
    }

    @JsxGetter
    public int getMaxLength() {
        String maxLength = this.getDomNodeOrDie().getAttribute("maxLength");
        try {
            return Integer.parseInt(maxLength);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @JsxSetter
    public void setMaxLength(String maxLength) {
        try {
            int i = Integer.parseInt(maxLength);
            if (i < 0) {
                throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "New value for maxLength '" + maxLength + "' is smaller than zero.", 1);
            }
            this.getDomNodeOrDie().setAttribute("maxLength", maxLength);
        }
        catch (NumberFormatException e) {
            this.getDomNodeOrDie().setAttribute("maxLength", "0");
        }
    }

    @JsxGetter
    public int getMinLength() {
        String minLength = this.getDomNodeOrDie().getAttribute("minLength");
        try {
            return Integer.parseInt(minLength);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @JsxSetter
    public void setMinLength(String minLength) {
        try {
            int i = Integer.parseInt(minLength);
            if (i < 0) {
                throw JavaScriptEngine.throwAsScriptRuntimeEx(new NumberFormatException("New value for minLength '" + minLength + "' is smaller than zero."));
            }
            this.getDomNodeOrDie().setAttribute("minLength", minLength);
        }
        catch (NumberFormatException e) {
            this.getDomNodeOrDie().setAttribute("minLength", "0");
        }
    }

    @JsxGetter
    public String getPlaceholder() {
        return this.getDomNodeOrDie().getPlaceholder();
    }

    @JsxSetter
    public void setPlaceholder(String placeholder) {
        this.getDomNodeOrDie().setPlaceholder(placeholder);
    }

    @JsxGetter
    public NodeList getLabels() {
        if (this.labels_ == null) {
            this.labels_ = new LabelsNodeList(this.getDomNodeOrDie());
        }
        return this.labels_;
    }

    @JsxFunction
    public boolean checkValidity() {
        return this.getDomNodeOrDie().isValid();
    }

    @JsxGetter
    public boolean isRequired() {
        return this.getDomNodeOrDie().isRequired();
    }

    @JsxSetter
    public void setRequired(boolean required) {
        this.getDomNodeOrDie().setRequired(required);
    }

    @Override
    @JsxGetter
    public String getName() {
        return super.getName();
    }

    @Override
    @JsxSetter
    public void setName(String newName) {
        super.setName(newName);
    }

    @Override
    @JsxGetter
    public boolean isDisabled() {
        return super.isDisabled();
    }

    @Override
    @JsxSetter
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
    }

    @Override
    @JsxGetter
    public HTMLFormElement getForm() {
        return super.getForm();
    }

    @JsxGetter
    public boolean getWillValidate() {
        return this.getDomNodeOrDie().willValidate();
    }

    @JsxGetter
    public ValidityState getValidity() {
        ValidityState validityState = new ValidityState();
        validityState.setPrototype(this.getPrototype(validityState.getClass()));
        validityState.setParentScope(this.getParentScope());
        validityState.setDomNode(this.getDomNodeOrDie());
        return validityState;
    }

    @JsxFunction
    public void setCustomValidity(String message) {
        this.getDomNodeOrDie().setCustomValidity(message);
    }
}

