/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.dom.RadioNodeList;
import org.htmlunit.javascript.host.html.HTMLCollection;

@JsxClass
public class HTMLFormControlsCollection
extends HTMLCollection {
    public HTMLFormControlsCollection() {
    }

    public HTMLFormControlsCollection(DomNode domNode, boolean attributeChangeSensitive) {
        super(domNode, attributeChangeSensitive);
    }

    HTMLFormControlsCollection(DomNode domNode, List<DomNode> initialElements) {
        super(domNode, initialElements);
    }

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @Override
    @JsxFunction
    public Scriptable namedItem(String name) {
        if (name.isEmpty()) {
            return null;
        }
        ArrayList<DomNode> elements = new ArrayList<DomNode>();
        for (DomNode next : this.getElements()) {
            if (!(next instanceof DomElement)) continue;
            DomElement elem = (DomElement)next;
            String nodeName = elem.getAttributeDirect("name");
            if (name.equals(nodeName)) {
                elements.add(elem);
                continue;
            }
            String id = elem.getId();
            if (!name.equals(id)) continue;
            elements.add(elem);
        }
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return this.getScriptableForElement(elements.get(0));
        }
        RadioNodeList nodeList = new RadioNodeList(this.getDomNodeOrDie(), elements);
        nodeList.setElementsSupplier(this.getElementSupplier());
        return nodeList;
    }

    @Override
    @JsxSymbol
    public Scriptable iterator() {
        return JavaScriptEngine.newArrayIteratorTypeValues(this.getParentScope(), (Scriptable)this);
    }
}

