/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.NativeObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.html.CharacterDataChangeEvent;
import org.htmlunit.html.CharacterDataChangeListener;
import org.htmlunit.html.HtmlAttributeChangeEvent;
import org.htmlunit.html.HtmlAttributeChangeListener;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxConstructorAlias;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.dom.MutationRecord;
import org.htmlunit.javascript.host.dom.Node;

@JsxClass
public class MutationObserver
extends HtmlUnitScriptable
implements HtmlAttributeChangeListener,
CharacterDataChangeListener {
    private Function function_;
    private Node node_;
    private boolean attaributes_;
    private boolean attributeOldValue_;
    private NativeArray attributeFilter_;
    private boolean characterData_;
    private boolean characterDataOldValue_;
    private boolean subtree_;

    @JsxConstructor
    @JsxConstructorAlias(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}, alias="WebKitMutationObserver")
    public void jsConstructor(Function function) {
        this.function_ = function;
    }

    @JsxFunction
    public void observe(Node node, NativeObject options) {
        if (node == null) {
            throw JavaScriptEngine.typeError("Node is undefined");
        }
        if (options == null) {
            throw JavaScriptEngine.typeError("Options is undefined");
        }
        this.node_ = node;
        this.attaributes_ = Boolean.TRUE.equals(options.get((Object)"attributes"));
        this.attributeOldValue_ = Boolean.TRUE.equals(options.get((Object)"attributeOldValue"));
        this.characterData_ = Boolean.TRUE.equals(options.get((Object)"characterData"));
        this.characterDataOldValue_ = Boolean.TRUE.equals(options.get((Object)"characterDataOldValue"));
        this.subtree_ = Boolean.TRUE.equals(options.get((Object)"subtree"));
        this.attributeFilter_ = (NativeArray)options.get((Object)"attributeFilter");
        boolean childList = Boolean.TRUE.equals(options.get((Object)"childList"));
        if (!(this.attaributes_ || childList || this.characterData_)) {
            throw JavaScriptEngine.typeError("One of childList, attributes, od characterData must be set");
        }
        if (this.attaributes_ && this.node_.getDomNodeOrDie() instanceof HtmlElement) {
            ((HtmlElement)this.node_.getDomNodeOrDie()).addHtmlAttributeChangeListener(this);
        }
        if (this.characterData_) {
            node.getDomNodeOrDie().addCharacterDataChangeListener(this);
        }
    }

    @JsxFunction
    public void disconnect() {
        if (this.attaributes_ && this.node_.getDomNodeOrDie() instanceof HtmlElement) {
            ((HtmlElement)this.node_.getDomNodeOrDie()).removeHtmlAttributeChangeListener(this);
        }
        if (this.characterData_) {
            this.node_.getDomNodeOrDie().removeCharacterDataChangeListener(this);
        }
    }

    @JsxFunction
    public Scriptable takeRecords() {
        return JavaScriptEngine.newArray(this.getParentScope(), 0);
    }

    @Override
    public void characterDataChanged(CharacterDataChangeEvent event) {
        Object target = event.getCharacterData().getScriptableObject();
        if (this.subtree_ || target == this.node_) {
            final MutationRecord mutationRecord = new MutationRecord();
            final Scriptable scope = this.getParentScope();
            mutationRecord.setParentScope(scope);
            mutationRecord.setPrototype(this.getPrototype(mutationRecord.getClass()));
            mutationRecord.setType("characterData");
            mutationRecord.setTarget((ScriptableObject)target);
            if (this.characterDataOldValue_) {
                mutationRecord.setOldValue(event.getOldValue());
            }
            Window window = this.getWindow();
            final HtmlPage owningPage = (HtmlPage)window.getDocument().getPage();
            final JavaScriptEngine jsEngine = (JavaScriptEngine)window.getWebWindow().getWebClient().getJavaScriptEngine();
            jsEngine.addPostponedAction(new PostponedAction(owningPage, "MutationObserver.characterDataChanged"){

                @Override
                public void execute() {
                    Scriptable array = JavaScriptEngine.newArray(scope, new Object[]{mutationRecord});
                    jsEngine.callFunction(owningPage, MutationObserver.this.function_, scope, (Scriptable)MutationObserver.this, new Object[]{array});
                }
            });
        }
    }

    @Override
    public void attributeAdded(HtmlAttributeChangeEvent event) {
        this.attributeChanged(event, "MutationObserver.attributeAdded", false);
    }

    @Override
    public void attributeRemoved(HtmlAttributeChangeEvent event) {
        this.attributeChanged(event, "MutationObserver.attributeRemoved", true);
    }

    @Override
    public void attributeReplaced(HtmlAttributeChangeEvent event) {
        this.attributeChanged(event, "MutationObserver.attributeReplaced", true);
    }

    private void attributeChanged(HtmlAttributeChangeEvent event, String actionTitle, boolean includeOldValue) {
        HtmlElement target = event.getHtmlElement();
        if (this.subtree_ || target == this.node_.getDomNodeOrDie()) {
            String attributeName = event.getName();
            if (this.attributeFilter_ == null || this.attributeFilter_.contains((Object)attributeName)) {
                final MutationRecord mutationRecord = new MutationRecord();
                final Scriptable scope = this.getParentScope();
                mutationRecord.setParentScope(scope);
                mutationRecord.setPrototype(this.getPrototype(mutationRecord.getClass()));
                mutationRecord.setAttributeName(attributeName);
                mutationRecord.setType("attributes");
                mutationRecord.setTarget((ScriptableObject)target.getScriptableObject());
                if (includeOldValue && this.attributeOldValue_) {
                    mutationRecord.setOldValue(event.getValue());
                }
                Window window = this.getWindow();
                final HtmlPage owningPage = (HtmlPage)window.getDocument().getPage();
                final JavaScriptEngine jsEngine = (JavaScriptEngine)window.getWebWindow().getWebClient().getJavaScriptEngine();
                jsEngine.addPostponedAction(new PostponedAction(owningPage, actionTitle){

                    @Override
                    public void execute() {
                        Scriptable array = JavaScriptEngine.newArray(scope, new Object[]{mutationRecord});
                        jsEngine.callFunction(owningPage, MutationObserver.this.function_, scope, (Scriptable)MutationObserver.this, new Object[]{array});
                    }
                });
            }
        }
    }
}

