/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.EcmaError;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.IdFunctionObject;
import org.htmlunit.corejs.javascript.JavaScriptException;
import org.htmlunit.corejs.javascript.NativeFunction;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.debug.DebuggableScript;
import org.htmlunit.javascript.DebugFrameAdapter;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.host.event.Event;

public class DebugFrameImpl
extends DebugFrameAdapter {
    private static final Log LOG = LogFactory.getLog(DebugFrameImpl.class);
    private static final String KEY_LAST_LINE = "DebugFrameImpl#line";
    private static final String KEY_LAST_SOURCE = "DebugFrameImpl#source";
    private final DebuggableScript functionOrScript_;

    public DebugFrameImpl(DebuggableScript functionOrScript) {
        this.functionOrScript_ = functionOrScript;
    }

    @Override
    public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
        if (LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            String line = DebugFrameImpl.getFirstLine(cx);
            String source = DebugFrameImpl.getSourceName(cx);
            sb.append(source).append(':').append(line).append(' ');
            for (Scriptable parent = activation.getParentScope(); parent != null; parent = parent.getParentScope()) {
                sb.append("   ");
            }
            String functionName = this.getFunctionName(thisObj);
            sb.append(functionName).append('(');
            int nbParams = this.functionOrScript_.getParamCount();
            for (int i = 0; i < nbParams; ++i) {
                String argAsString = i < args.length ? DebugFrameImpl.stringValue(args[i]) : "undefined";
                sb.append(this.getParamName(i)).append(": ").append(argAsString);
                if (i >= nbParams - 1) continue;
                sb.append(", ");
            }
            sb.append(')');
            LOG.trace((Object)sb);
        }
    }

    private static String stringValue(Object arg) {
        Object asString;
        if (arg instanceof NativeFunction) {
            String name = (String)StringUtils.defaultIfEmpty((CharSequence)((NativeFunction)arg).getFunctionName(), (CharSequence)"anonymous");
            return "[function " + name + "]";
        }
        if (arg instanceof IdFunctionObject) {
            return "[function " + ((IdFunctionObject)arg).getFunctionName() + "]";
        }
        if (arg instanceof Function) {
            return "[function anonymous]";
        }
        try {
            asString = JavaScriptEngine.toString(arg);
            if (arg instanceof Event) {
                asString = (String)asString + "<" + ((Event)arg).getType() + ">";
            }
        }
        catch (Throwable e) {
            asString = String.valueOf(arg);
        }
        return asString;
    }

    @Override
    public void onExceptionThrown(Context cx, Throwable t) {
        if (LOG.isTraceEnabled()) {
            if (t instanceof JavaScriptException) {
                JavaScriptException e = (JavaScriptException)t;
                LOG.trace((Object)(DebugFrameImpl.getSourceName(cx) + ":" + DebugFrameImpl.getFirstLine(cx) + " Exception thrown: " + e.details()));
            } else if (t instanceof EcmaError) {
                EcmaError e = (EcmaError)t;
                LOG.trace((Object)(DebugFrameImpl.getSourceName(cx) + ":" + DebugFrameImpl.getFirstLine(cx) + " Exception thrown: " + e.details()));
            } else {
                LOG.trace((Object)(DebugFrameImpl.getSourceName(cx) + ":" + DebugFrameImpl.getFirstLine(cx) + " Exception thrown: " + String.valueOf(t.getCause())));
            }
        }
    }

    @Override
    public void onLineChange(Context cx, int lineNumber) {
        cx.putThreadLocal((Object)KEY_LAST_LINE, (Object)lineNumber);
        cx.putThreadLocal((Object)KEY_LAST_SOURCE, (Object)this.functionOrScript_.getSourceName());
    }

    private String getFunctionName(Scriptable thisObj) {
        if (this.functionOrScript_.isFunction()) {
            String name = this.functionOrScript_.getFunctionName();
            if (name != null && !name.isEmpty()) {
                return name;
            }
            if (thisObj instanceof HtmlUnitScriptable) {
                return "[anonymous]";
            }
            for (Scriptable obj = thisObj; obj != null; obj = obj.getPrototype()) {
                for (Object id : obj.getIds()) {
                    NativeFunction f;
                    Object o;
                    if (!(id instanceof String)) continue;
                    String s = (String)id;
                    if (obj instanceof ScriptableObject) {
                        o = ((ScriptableObject)obj).getGetterOrSetter(s, 0, thisObj, false);
                        if (o == null) {
                            o = ((ScriptableObject)obj).getGetterOrSetter(s, 0, thisObj, true);
                            if (o != null) {
                                return "__defineSetter__ " + s;
                            }
                        } else {
                            return "__defineGetter__ " + s;
                        }
                    }
                    try {
                        o = obj.get(s, obj);
                    }
                    catch (Exception e) {
                        return "[anonymous]";
                    }
                    if (!(o instanceof NativeFunction) || (f = (NativeFunction)o).getDebuggableView() != this.functionOrScript_) continue;
                    return s;
                }
            }
            return "[anonymous]";
        }
        return "[script]";
    }

    private String getParamName(int index) {
        if (index >= 0 && this.functionOrScript_.getParamCount() > index) {
            return this.functionOrScript_.getParamOrVarName(index);
        }
        return "???";
    }

    private static String getSourceName(Context cx) {
        String source = (String)cx.getThreadLocal((Object)KEY_LAST_SOURCE);
        if (source == null) {
            return "unknown";
        }
        source = StringUtils.substringAfterLast((String)source, (String)"/");
        source = StringUtils.substringBefore((String)source, (String)" ");
        return source;
    }

    private static String getFirstLine(Context cx) {
        Object line = cx.getThreadLocal((Object)KEY_LAST_LINE);
        String result = line == null ? "??" : String.valueOf(line);
        return StringUtils.leftPad((String)result, (int)5);
    }
}

