/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.htmlunit.html.DefaultElementFactory;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.util.OrderedFastHashMap;
import org.htmlunit.util.StringUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class NamedAttrNodeMapImpl
implements Map<String, DomAttr>,
NamedNodeMap,
Serializable {
    private final OrderedFastHashMap<String, DomAttr> map_;
    private final DomElement domNode_;
    private final boolean caseSensitive_;

    NamedAttrNodeMapImpl(DomElement domNode, boolean caseSensitive) {
        if (domNode == null) {
            throw new IllegalArgumentException("Provided domNode can't be null.");
        }
        this.domNode_ = domNode;
        this.caseSensitive_ = caseSensitive;
        this.map_ = new OrderedFastHashMap(0);
    }

    NamedAttrNodeMapImpl(DomElement domNode, boolean caseSensitive, Map<String, DomAttr> attributes) {
        if (domNode == null) {
            throw new IllegalArgumentException("Provided domNode can't be null.");
        }
        this.domNode_ = domNode;
        this.caseSensitive_ = caseSensitive;
        if (attributes instanceof DefaultElementFactory.OrderedFastHashMapWithLowercaseKeys) {
            this.map_ = (OrderedFastHashMap)attributes;
        } else if (caseSensitive && attributes instanceof OrderedFastHashMap) {
            this.map_ = (OrderedFastHashMap)attributes;
        } else {
            this.map_ = new OrderedFastHashMap(attributes.size());
            this.putAll((Map<? extends String, ? extends DomAttr>)attributes);
        }
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public DomAttr getNamedItem(String name) {
        return this.get(name);
    }

    private String fixName(String name) {
        if (this.caseSensitive_) {
            return name;
        }
        return StringUtils.toRootLowerCase(name);
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) {
        if (this.domNode_ == null) {
            return null;
        }
        return this.get(this.domNode_.getQualifiedName(namespaceURI, this.fixName(localName)));
    }

    @Override
    public Node item(int index) {
        if (index < 0 || index >= this.map_.size()) {
            return null;
        }
        return this.map_.getValue(index);
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        return this.remove(name);
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) {
        if (this.domNode_ == null) {
            return null;
        }
        return this.remove(this.domNode_.getQualifiedName(namespaceURI, this.fixName(localName)));
    }

    @Override
    public DomAttr setNamedItem(Node node) {
        return this.put(node.getLocalName(), (DomAttr)node);
    }

    @Override
    public Node setNamedItemNS(Node node) throws DOMException {
        return this.put(node.getNodeName(), (DomAttr)node);
    }

    @Override
    public DomAttr put(String key, DomAttr value) {
        String name = this.fixName(key);
        return this.map_.put(name, value);
    }

    @Override
    public DomAttr remove(Object key) {
        if (key instanceof String) {
            String name = this.fixName((String)key);
            return this.map_.remove(name);
        }
        return null;
    }

    @Override
    public void clear() {
        this.map_.clear();
    }

    @Override
    public void putAll(Map<? extends String, ? extends DomAttr> t) {
        for (Map.Entry<? extends String, ? extends DomAttr> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String name = this.fixName((String)key);
            return this.map_.containsKey(name);
        }
        return false;
    }

    @Override
    public DomAttr get(Object key) {
        if (key instanceof String) {
            String name = this.fixName((String)key);
            return this.map_.get(name);
        }
        return null;
    }

    protected DomAttr getDirect(String key) {
        return this.map_.get(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map_.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, DomAttr>> entrySet() {
        return this.map_.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.map_.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map_.keySet();
    }

    @Override
    public int size() {
        return this.map_.size();
    }

    @Override
    public Collection<DomAttr> values() {
        return this.map_.values();
    }
}

