/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.css;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class CssColors {
    private static final Map<String, String> CSS_COLORS = new HashMap<String, String>();

    private CssColors() {
    }

    public static boolean isColorKeyword(String token) {
        return CSS_COLORS.containsKey(token.toLowerCase(Locale.ROOT));
    }

    public static String toRGBColor(String color) {
        String rgbValue = CSS_COLORS.get(color.toLowerCase(Locale.ROOT));
        if (rgbValue != null) {
            return rgbValue;
        }
        return color;
    }

    static {
        CSS_COLORS.put("aqua", "rgb(0, 255, 255)");
        CSS_COLORS.put("black", "rgb(0, 0, 0)");
        CSS_COLORS.put("blue", "rgb(0, 0, 255)");
        CSS_COLORS.put("fuchsia", "rgb(255, 0, 255)");
        CSS_COLORS.put("gray", "rgb(128, 128, 128)");
        CSS_COLORS.put("green", "rgb(0, 128, 0)");
        CSS_COLORS.put("lime", "rgb(0, 255, 0)");
        CSS_COLORS.put("maroon", "rgb(128, 0, 0)");
        CSS_COLORS.put("navy", "rgb(0, 0, 128)");
        CSS_COLORS.put("olive", "rgb(128, 128, 0)");
        CSS_COLORS.put("purple", "rgb(128, 0, 128)");
        CSS_COLORS.put("red", "rgb(255, 0, 0)");
        CSS_COLORS.put("silver", "rgb(192, 192, 192)");
        CSS_COLORS.put("teal", "rgb(0, 128, 128)");
        CSS_COLORS.put("white", "rgb(255, 255, 255)");
        CSS_COLORS.put("yellow", "rgb(255, 255, 0)");
    }
}

