/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.WebResponseData;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.StringUtils;

public class StringWebResponse
extends WebResponse {
    private boolean fromJavascript_;

    public StringWebResponse(String content, URL originatingURL) {
        this(content, StandardCharsets.UTF_8, originatingURL);
    }

    public StringWebResponse(String content, Charset charset, URL originatingURL) {
        super(StringWebResponse.getWebResponseData(content, charset), StringWebResponse.buildWebRequest(originatingURL, charset), 0L);
    }

    private static WebResponseData getWebResponseData(String contentString, Charset charset) {
        byte[] content = StringUtils.toByteArray(contentString, charset);
        ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>();
        compiledHeaders.add(new NameValuePair("Content-Type", "text/html; charset=" + String.valueOf(charset)));
        return new WebResponseData(content, 200, "OK", compiledHeaders);
    }

    private static WebRequest buildWebRequest(URL originatingURL, Charset charset) {
        WebRequest webRequest = new WebRequest(originatingURL, HttpMethod.GET);
        webRequest.setCharset(charset);
        return webRequest;
    }

    public boolean isFromJavascript() {
        return this.fromJavascript_;
    }

    public void setFromJavascript(boolean fromJavascript) {
        this.fromJavascript_ = fromJavascript;
    }
}

