/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.util.SplitMix64RandomGenerator;
import java.util.List;

public class FastRandom {
    private long s0;
    private long s1;
    private long s2;
    private long s3;
    public static final String LOWERCHARS = "abcdefghijklmnopqrstuvwxyz";
    public static final String UPPERCHARS = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    public static final String CHARS = "abcdefghijklmnopqrstuvwxyz" + UPPERCHARS;
    public static final String NUMBERS = "0123456789";
    public static final String ALPHANUMERIC_ALL = CHARS + "0123456789";
    public static final String ALPHANUMERIC_LOWER = "abcdefghijklmnopqrstuvwxyz0123456789";
    public static final String ALPHANUMERIC_UPPER = UPPERCHARS + "0123456789";

    protected FastRandom(long s0, long s1, long s2, long s3) {
        this.s0 = s0;
        this.s1 = s1;
        this.s2 = s2;
        this.s3 = s3;
    }

    public FastRandom(long seed) {
        this.setSeed(seed);
    }

    public long nextLong() {
        long t0 = this.s0;
        long result = Long.rotateLeft(t0 + this.s3, 23) + t0;
        long t = this.s1 << 17;
        this.s2 ^= t0;
        this.s3 ^= this.s1;
        this.s1 ^= this.s2;
        this.s0 ^= this.s3;
        this.s2 ^= t;
        this.s3 = Long.rotateLeft(this.s3, 45);
        return result;
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    public int nextInt(int from, int to) {
        return from + this.nextInt(to - from + 1);
    }

    public long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("illegal bound " + n + " (must be positive)");
        }
        long t = this.nextLong();
        long nMinus1 = n - 1L;
        long u = t >>> 1;
        while (u + nMinus1 - (t = u % n) < 0L) {
            u = this.nextLong() >>> 1;
        }
        return t;
    }

    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    public double nextDoubleFast() {
        return Double.longBitsToDouble(0x3FF0000000000000L | this.nextLong() >>> 12) - 1.0;
    }

    public float nextFloat() {
        return (float)(this.nextLong() >>> 40) * 5.9604645E-8f;
    }

    public boolean nextBoolean() {
        return this.nextLong() < 0L;
    }

    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        int n = 0;
        while (i != 0) {
            n = Math.min(i, 8);
            long bits = this.nextLong();
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    public void setSeed(long seed) {
        SplitMix64RandomGenerator r = new SplitMix64RandomGenerator(seed);
        this.s0 = r.nextLong();
        this.s1 = r.nextLong();
        this.s2 = r.nextLong();
        this.s3 = r.nextLong();
    }

    public static FastRandom get(long seed, long ... additionalSeeds) {
        long l = SplitMix64RandomGenerator.murmurHash3(seed);
        for (int i = 0; i < additionalSeeds.length; ++i) {
            l = 31L * l + SplitMix64RandomGenerator.murmurHash3(additionalSeeds[i]);
        }
        return new FastRandom(l);
    }

    public static FastRandom get(int seed, int ... additionalSeeds) {
        long[] longArray = new long[additionalSeeds.length];
        for (int i = 0; i < additionalSeeds.length; ++i) {
            longArray[i] = FastRandom.int2significantLong(additionalSeeds[i]);
        }
        return FastRandom.get(FastRandom.int2significantLong(seed), longArray);
    }

    public static long int2significantLong(int i) {
        long r = ((long)i << 32) + (long)i;
        return r;
    }

    public String randomString(String source, int length) {
        return this.randomString(source, length, length);
    }

    public String randomString(String source, int from, int to) {
        int length = this.nextInt(to - from + 1) + from;
        StringBuilder sb = new StringBuilder(to);
        for (int i = 0; i < length; ++i) {
            int pos = this.nextInt(source.length());
            sb.append(source.charAt(pos));
        }
        return sb.toString();
    }

    public <T> T randomEntry(List<T> list) {
        if (!list.isEmpty()) {
            return list.get(this.nextInt(list.size()));
        }
        return null;
    }
}

