/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressBar {
    private final int total;
    private int nextStep = 0;
    private int currentCount = 0;
    private final boolean isStarted = false;
    private static final Logger log = LoggerFactory.getLogger(ProgressBar.class);

    public ProgressBar(int total) {
        if (total < 0) {
            throw new IllegalArgumentException("Given total must be 0 or higher but was : " + total);
        }
        this.total = total;
    }

    public synchronized void start() {
        this.setCount(0);
    }

    public synchronized void increaseCount() {
        if (this.currentCount < this.total) {
            ++this.currentCount;
            this.setCount(this.currentCount);
        } else {
            log.warn("ProgressBar reached max value.");
        }
    }

    public synchronized void increaseCount(int add) {
        if (add < 0) {
            throw new IllegalArgumentException(String.format("Added value must be positive but was '%d'", add));
        }
        this.setCount(this.currentCount + add);
    }

    public synchronized void setCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be >= 0");
        }
        if (count > this.total) {
            log.warn(String.format("ProgressBar started to overflow, total: %d, count: %d", this.total, count));
            return;
        }
        this.currentCount = count;
        int percent = count * 100 / this.total;
        this.setPercent(percent);
    }

    public synchronized void setCompleted() {
        this.setCount(this.total);
    }

    public synchronized int getTotal() {
        return this.total;
    }

    public synchronized int getCurrentCount() {
        return this.currentCount;
    }

    public synchronized void setPercent(int percent) {
        if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException(String.format("Percent must be one of [0 .. 100] but was '%d'", percent));
        }
        if (percent >= this.nextStep) {
            boolean isStart;
            boolean bl = isStart = this.nextStep == 0;
            while (percent >= this.nextStep) {
                this.nextStep += 10;
            }
            int currentStep = isStart ? 0 : this.nextStep - 10;
            String keepOn = percent < 100 ? "... " : "";
            String step = String.format("%d%s %s", currentStep, "%", keepOn);
            System.out.print(step);
        }
    }
}

