/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.util;

import com.xceptance.xlt.util.FileReplicationIndex;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;

public final class FileReplicationUtils {
    static char SEP = File.separatorChar;

    public static FileReplicationIndex sanitizeFileReplicationIndex(FileReplicationIndex sourceIndex) {
        FileReplicationIndex result = new FileReplicationIndex();
        char currentSeparatorChar = SEP;
        char separatorCharToChange = SEP == '/' ? (char)'\\' : '/';
        for (Map.Entry entry : sourceIndex.entrySet()) {
            File key = (File)entry.getKey();
            Long value = (Long)entry.getValue();
            String sanitizedPath = key.getPath().replace(separatorCharToChange, currentSeparatorChar);
            File newFile = new File(sanitizedPath);
            result.put(newFile, value);
        }
        return result;
    }

    public static void compareIndexes(FileReplicationIndex sourceIndex, FileReplicationIndex targetIndex, List<File> filesToBeUpdated, List<File> filesToBeDeleted) {
        FileReplicationIndex _sourceIndex = FileReplicationUtils.sanitizeFileReplicationIndex(sourceIndex);
        FileReplicationIndex _targetIndex = FileReplicationUtils.sanitizeFileReplicationIndex(targetIndex);
        for (Map.Entry entry : _sourceIndex.entrySet()) {
            File file = (File)entry.getKey();
            long sourceCheckSum = (Long)entry.getValue();
            Long targetCheckSum = (Long)_targetIndex.get(file);
            if (targetCheckSum == null) {
                filesToBeUpdated.add(file);
                continue;
            }
            if (targetCheckSum != sourceCheckSum || sourceCheckSum == -1L) {
                filesToBeUpdated.add(file);
            }
            _targetIndex.remove(file);
        }
        for (File file2add : _targetIndex.keySet()) {
            boolean addFile = true;
            String filePath2add = file2add.getPath();
            Iterator<File> it = filesToBeDeleted.iterator();
            while (it.hasNext()) {
                File fileContained = it.next();
                String filePathContained = fileContained.getPath();
                if (filePath2add.startsWith(filePathContained + SEP)) {
                    addFile = false;
                    break;
                }
                if (!filePathContained.startsWith(filePath2add + SEP)) continue;
                it.remove();
            }
            if (!addFile) continue;
            filesToBeDeleted.add(file2add);
        }
    }

    public static FileReplicationIndex getIndex(File directory) {
        return FileReplicationUtils.getIndex(directory, null);
    }

    public static FileReplicationIndex getIndex(File directory, FileFilter fileFilter) {
        FileReplicationIndex index = new FileReplicationIndex();
        FileReplicationUtils.updateIndex(index, directory, new File("."), fileFilter);
        return index;
    }

    private static void updateIndex(FileReplicationIndex index, File directory, File relativeDirectory, FileFilter fileFilter) {
        File[] files = directory.listFiles(fileFilter);
        if (files != null) {
            for (File file : files) {
                File relativeFilePath = new File(relativeDirectory, file.getName());
                long checkSum = FileReplicationUtils.calculateCheckSum(file);
                index.put(relativeFilePath, checkSum);
                if (!file.isDirectory()) continue;
                FileReplicationUtils.updateIndex(index, file, new File(relativeDirectory, file.getName()), fileFilter);
            }
        }
    }

    private static long calculateCheckSum(File file) {
        long l;
        if (file.isDirectory()) {
            return -1L;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            int bytesRead;
            CRC32 checkSum = new CRC32();
            byte[] buffer = new byte[65536];
            while ((bytesRead = in.read(buffer)) >= 0) {
                checkSum.update(buffer, 0, bytesRead);
            }
            l = checkSum.getValue();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to calculate check sum for file: " + String.valueOf(file), ex);
            }
        }
        in.close();
        return l;
    }

    private FileReplicationUtils() {
    }
}

