/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.xlt.report.util.IntMinMaxValueSet;
import java.util.Arrays;

public class ValueSet {
    public static final int DEFAULT_SIZE = 1024;
    private long firstSecond;
    private long lastSecond;
    private long maximumTime;
    private long minimumTime;
    private int size;
    private long valueCount;
    private int[] values;

    public ValueSet() {
        this(1024);
    }

    private ValueSet(int size) {
        this.size = size;
        this.values = new int[size];
    }

    public void addOrUpdateValue(long time, int value) {
        long second = time / 1000L;
        if (this.valueCount == 0L) {
            this.firstSecond = this.lastSecond = second;
            this.values[0] = value;
            this.minimumTime = this.maximumTime = time;
            this.valueCount = 1L;
        } else {
            int index;
            if (second != this.firstSecond) {
                if (second > this.firstSecond) {
                    while (second - this.firstSecond >= (long)this.size) {
                        this.grow();
                    }
                    if (second > this.lastSecond) {
                        this.lastSecond = second;
                    }
                } else {
                    while (this.lastSecond - second >= (long)this.size) {
                        this.grow();
                    }
                    int indexDiff = (int)(this.firstSecond - second);
                    this.shift(indexDiff);
                    this.firstSecond = second;
                }
            }
            int n = index = (int)(second - this.firstSecond);
            this.values[n] = this.values[n] + value;
            ++this.valueCount;
            if (time < this.minimumTime) {
                this.minimumTime = time;
            }
            if (time > this.maximumTime) {
                this.maximumTime = time;
            }
        }
    }

    public long getFirstSecond() {
        this.checkValueCount("No first second available because no values have been added so far.");
        return this.firstSecond;
    }

    public long getLastSecond() {
        this.checkValueCount("No last second available because no values have been added so far.");
        return this.lastSecond;
    }

    public long getLengthInSeconds() {
        this.checkValueCount("No length available because no values have been added so far.");
        return this.lastSecond - this.firstSecond + 1L;
    }

    public long getMaximumTime() {
        this.checkValueCount("No maximum time available as no values have been added so far.");
        return this.maximumTime;
    }

    public long getMinimumTime() {
        this.checkValueCount("No minimum time available as no values have been added so far.");
        return this.minimumTime;
    }

    private void checkValueCount(String message) {
        if (this.valueCount == 0L) {
            throw new IllegalStateException(message);
        }
    }

    public long getValueCount() {
        return this.valueCount;
    }

    public int[] getValues() {
        int[] copy;
        if (this.valueCount == 0L) {
            copy = new int[]{};
        } else {
            int length = (int)(this.lastSecond - this.firstSecond + 1L);
            copy = new int[length];
            System.arraycopy(this.values, 0, copy, 0, length);
        }
        return copy;
    }

    public IntMinMaxValueSet toMinMaxValueSet(int size) {
        IntMinMaxValueSet minMaxValueSet = new IntMinMaxValueSet(size);
        if (this.valueCount > 0L) {
            int actualSize = (int)(this.lastSecond - this.firstSecond + 1L);
            long time = this.firstSecond * 1000L;
            int i = 0;
            while (i < actualSize) {
                minMaxValueSet.addOrUpdateValue(time, this.values[i]);
                ++i;
                time += 1000L;
            }
        }
        return minMaxValueSet;
    }

    private void shift(int indexDiff) {
        System.arraycopy(this.values, 0, this.values, indexDiff, this.size - indexDiff);
        for (int i = 0; i < indexDiff; ++i) {
            this.values[i] = 0;
        }
    }

    private void grow() {
        int[] newValues = new int[2 * this.size];
        System.arraycopy(this.values, 0, newValues, 0, this.size);
        this.size *= 2;
        this.values = newValues;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueSet other = (ValueSet)obj;
        if (this.firstSecond != other.firstSecond) {
            return false;
        }
        if (this.lastSecond != other.lastSecond) {
            return false;
        }
        if (this.maximumTime != other.maximumTime) {
            return false;
        }
        if (this.minimumTime != other.minimumTime) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.valueCount != other.valueCount) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstSecond ^ this.firstSecond >>> 32);
        result = 31 * result + (int)(this.lastSecond ^ this.lastSecond >>> 32);
        result = 31 * result + (int)(this.maximumTime ^ this.maximumTime >>> 32);
        result = 31 * result + (int)(this.minimumTime ^ this.minimumTime >>> 32);
        result = 31 * result + this.size;
        result = 31 * result + (int)(this.valueCount ^ this.valueCount >>> 32);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }
}

