/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtils;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class MinMaxRenderer
extends XYLineAndShapeRenderer {
    private static final long serialVersionUID = 4097521103727872464L;

    public MinMaxRenderer(boolean lines, boolean shapes) {
        super(lines, shapes);
        this.setDrawSeriesLineAsPath(true);
    }

    protected void drawPrimaryLineAsPath(XYItemRendererState state, Graphics2D g2, XYPlot plot, XYDataset dataset, int pass, int series, int item, ValueAxis domainAxis, ValueAxis rangeAxis, Rectangle2D dataArea) {
        IntervalXYDataset data = (IntervalXYDataset)dataset;
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double x = data.getXValue(series, item);
        double yLow = data.getStartYValue(series, item);
        double yHigh = data.getEndYValue(series, item);
        double xx = domainAxis.valueToJava2D(x, dataArea, xAxisLocation);
        double yyLow = rangeAxis.valueToJava2D(yLow, dataArea, yAxisLocation);
        double yyHigh = rangeAxis.valueToJava2D(yHigh, dataArea, yAxisLocation);
        XYLineAndShapeRenderer.State s = (XYLineAndShapeRenderer.State)state;
        if (!(Double.isNaN(xx) || Double.isNaN(yyLow) || Double.isNaN(yyHigh))) {
            PlotOrientation orientation = plot.getOrientation();
            if (orientation == PlotOrientation.HORIZONTAL) {
                float xxxLow = (float)yyHigh;
                float xxxHigh = (float)yyLow;
                float yyy = (float)xx;
                if (s.isLastPointGood()) {
                    s.seriesPath.lineTo(xxxLow, yyy);
                } else {
                    s.seriesPath.moveTo(xxxLow, yyy);
                }
                if (xxxHigh != xxxLow) {
                    s.seriesPath.lineTo(xxxHigh, yyy);
                }
            } else {
                float xxx = (float)xx;
                float yyyLow = (float)yyLow;
                float yyyHigh = (float)yyHigh;
                if (s.isLastPointGood()) {
                    s.seriesPath.lineTo(xxx, yyyHigh);
                } else {
                    s.seriesPath.moveTo(xxx, yyyHigh);
                }
                if (yyyHigh != yyyLow) {
                    s.seriesPath.lineTo(xxx, yyyLow);
                }
            }
            s.setLastPointGood(true);
        } else {
            s.setLastPointGood(false);
        }
        if (item == s.getLastItemIndex()) {
            this.drawFirstPassShape(g2, pass, series, item, s.seriesPath);
        }
    }

    public Range findRangeBounds(XYDataset dataset) {
        if (dataset != null) {
            return DatasetUtils.findRangeBounds((XYDataset)dataset, (boolean)true);
        }
        return null;
    }
}

