/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

public class IntSummaryStatistics {
    private long count;
    private int maximum = Integer.MIN_VALUE;
    private int minimum = Integer.MAX_VALUE;
    private double sum;
    private double sumOfSquares;

    public void addValue(int value) {
        this.sumOfSquares += Math.pow(value, 2.0);
        this.sum += (double)value;
        this.maximum = Math.max(this.maximum, value);
        this.minimum = Math.min(this.minimum, value);
        ++this.count;
    }

    public long getCount() {
        return this.count;
    }

    public int getMaximum() {
        return this.count == 0L ? 0 : this.maximum;
    }

    public double getMean() {
        return this.sum / (double)this.count;
    }

    public int getMinimum() {
        return this.count == 0L ? 0 : this.minimum;
    }

    public double getStandardDeviation() {
        double mean = this.getMean();
        return Math.sqrt(this.sumOfSquares / (double)this.count - mean * mean);
    }

    public double getSum() {
        return this.sum;
    }
}

