/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.common.util.ParameterCheckUtils;
import java.util.Arrays;
import org.jfree.data.xy.XYIntervalSeries;

public class FixedSizeHistogramValueSet {
    private final int bucketCount;
    private int bucketWidth;
    private final int[] countPerBucket;

    public FixedSizeHistogramValueSet(int bucketCount) {
        ParameterCheckUtils.isGreaterThan(bucketCount, 0, "bucketCount");
        this.bucketCount = bucketCount % 2 == 1 ? bucketCount + 1 : bucketCount;
        this.countPerBucket = new int[this.bucketCount];
        this.bucketWidth = 1;
    }

    public void addValue(int value) {
        if (value < 0) {
            return;
        }
        value /= this.bucketWidth;
        while (value >= this.bucketCount) {
            this.scale();
            value /= 2;
        }
        int n = value;
        this.countPerBucket[n] = this.countPerBucket[n] + 1;
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public int[] getCountPerBucket() {
        return this.countPerBucket;
    }

    public int getMaximumCount() {
        int maxCount = 0;
        for (int count : this.countPerBucket) {
            maxCount = Math.max(maxCount, count);
        }
        return maxCount;
    }

    public XYIntervalSeries toSeries(String seriesName) {
        XYIntervalSeries series = new XYIntervalSeries((Comparable)((Object)seriesName));
        int bucketStartValue = 0;
        int bucketEndValue = this.bucketWidth;
        for (int i = 0; i < this.countPerBucket.length; ++i) {
            int count = this.countPerBucket[i];
            if (count > 0) {
                series.add((double)count, 0.0, (double)count, (double)bucketEndValue, (double)bucketStartValue, (double)bucketEndValue);
            }
            bucketStartValue = bucketEndValue;
            bucketEndValue += this.bucketWidth;
        }
        return series;
    }

    public XYIntervalSeries toVerticalSeries(String seriesName) {
        XYIntervalSeries series = new XYIntervalSeries((Comparable)((Object)seriesName));
        int bucketStartValue = 0;
        int bucketEndValue = this.bucketWidth;
        for (int i = 0; i < this.countPerBucket.length; ++i) {
            int count = this.countPerBucket[i];
            if (count > 0) {
                series.add((double)bucketEndValue, (double)bucketStartValue, (double)bucketEndValue, (double)count, 0.0, (double)count);
            }
            bucketStartValue = bucketEndValue;
            bucketEndValue += this.bucketWidth;
        }
        return series;
    }

    private void scale() {
        this.bucketWidth *= 2;
        for (int i = 0; i < this.bucketCount; i += 2) {
            int newBucketIndex = i / 2;
            this.countPerBucket[newBucketIndex] = this.countPerBucket[i] + this.countPerBucket[i + 1];
        }
        Arrays.fill(this.countPerBucket, this.bucketCount / 2, this.bucketCount, 0);
    }
}

