/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

public class DoubleSummaryStatistics {
    private long count;
    private double maximum = Double.MIN_VALUE;
    private double minimum = Double.MAX_VALUE;
    private double sum;
    private double sumOfSquares;

    public void addValue(double value) {
        this.sumOfSquares += Math.pow(value, 2.0);
        ++this.count;
        this.maximum = Math.max(this.maximum, value);
        this.minimum = Math.min(this.minimum, value);
        this.sum += value;
    }

    public long getCount() {
        return this.count;
    }

    public double getMaximum() {
        return this.count == 0L ? 0.0 : this.maximum;
    }

    public double getMean() {
        return this.sum / (double)this.count;
    }

    public double getMinimum() {
        return this.count == 0L ? 0.0 : this.minimum;
    }

    public double getStandardDeviation() {
        double mean = this.getMean();
        return Math.sqrt(this.sumOfSquares / (double)this.count - mean * mean);
    }

    public double getSum() {
        return this.sum;
    }
}

