/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.xlt.report.util.MinMaxTimeSeriesCollection;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtils;
import org.jfree.data.xy.XYDataset;

public class DotsRenderer
extends XYDotRenderer {
    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        if (!this.getItemVisible(series, item)) {
            return;
        }
        MinMaxTimeSeriesCollection data = (MinMaxTimeSeriesCollection)dataset;
        double x = data.getXValue(series, item);
        double[] yValues = data.getValues(series, item);
        if (yValues.length > 0) {
            int dotWidth = this.getDotWidth();
            int dotHeight = this.getDotHeight();
            double adjx = (double)(dotWidth - 1) / 2.0;
            double adjy = (double)(dotHeight - 1) / 2.0;
            RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
            RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
            g2.setPaint(this.getItemPaint(series, item));
            double transX = domainAxis.valueToJava2D(x, dataArea, xAxisLocation) - adjx;
            for (double y : yValues) {
                double transY = rangeAxis.valueToJava2D(y, dataArea, yAxisLocation) - adjy;
                PlotOrientation orientation = plot.getOrientation();
                if (orientation == PlotOrientation.HORIZONTAL) {
                    g2.fillRect((int)transY, (int)transX, dotHeight, dotWidth);
                    continue;
                }
                if (orientation != PlotOrientation.VERTICAL) continue;
                g2.fillRect((int)transX, (int)transY, dotWidth, dotHeight);
            }
        }
    }

    public Range findRangeBounds(XYDataset dataset) {
        if (dataset != null) {
            return DatasetUtils.findRangeBounds((XYDataset)dataset, (boolean)true);
        }
        return null;
    }
}

