/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.xlt.report.util.ValueSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ConcurrentUsersTable {
    private static ConcurrentUsersTable singleton = new ConcurrentUsersTable();
    private final Map<String, BitSet> bitSetsByUserId = new TreeMap<String, BitSet>();
    private final Map<String, List<BitSet>> bitSetsByUserName = new HashMap<String, List<BitSet>>();
    private long start = Long.MAX_VALUE;

    public static ConcurrentUsersTable getInstance() {
        return singleton;
    }

    private ConcurrentUsersTable() {
    }

    public void clear() {
        this.bitSetsByUserId.clear();
        this.bitSetsByUserName.clear();
        this.start = Long.MAX_VALUE;
    }

    public void recordUserActivity(long fromTimestamp, long toTimestamp, String userName, String userNumber) {
        String userId = userName + "-" + userNumber;
        BitSet bitSet = this.bitSetsByUserId.get(userId);
        if (bitSet == null) {
            bitSet = new BitSet();
            this.bitSetsByUserId.put(userId, bitSet);
            List<BitSet> bitSets = this.bitSetsByUserName.get(userName);
            if (bitSets == null) {
                bitSets = new ArrayList<BitSet>();
                this.bitSetsByUserName.put(userName, bitSets);
            }
            bitSets.add(bitSet);
        }
        this.shiftAllBitSetsIfRequired(fromTimestamp /= 1000L);
        int offset = (int)(fromTimestamp - this.start);
        int range = (int)((toTimestamp /= 1000L) - fromTimestamp);
        for (int i = 0; i <= range; ++i) {
            bitSet.set(offset + i);
        }
    }

    public ValueSet getConcurrentUsersValueSet() {
        return this.getConcurrentUsersValueSet(null);
    }

    public ValueSet getConcurrentUsersValueSet(String userName) {
        Collection bitSets = userName == null || userName.equals("All Transactions") ? this.bitSetsByUserId.values() : (Collection)this.bitSetsByUserName.get(userName);
        ValueSet valueSet = new ValueSet();
        if (bitSets != null) {
            for (BitSet bitSet : bitSets) {
                int i = bitSet.nextSetBit(0);
                while (i >= 0) {
                    long timeMS = ((long)i + this.start) * 1000L;
                    valueSet.addOrUpdateValue(timeMS, 1);
                    i = bitSet.nextSetBit(i + 1);
                }
            }
        }
        return valueSet;
    }

    private void shiftAllBitSetsIfRequired(long fromTimestamp) {
        if (fromTimestamp < this.start) {
            int shift = (int)(this.start - fromTimestamp);
            for (BitSet bitSet : this.bitSetsByUserId.values()) {
                this.shiftBitSet(bitSet, shift);
            }
            this.start = fromTimestamp;
        }
    }

    private void shiftBitSet(BitSet bitSet, int shift) {
        if (!bitSet.isEmpty()) {
            BitSet tmpBitSet = (BitSet)bitSet.clone();
            bitSet.clear();
            int i = tmpBitSet.nextSetBit(0);
            while (i >= 0) {
                bitSet.set(shift + i);
                i = tmpBitSet.nextSetBit(i + 1);
            }
        }
    }

    public String toString() {
        if (this.bitSetsByUserId.size() == 0) {
            return "Bit table is empty.";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, BitSet> entry : this.bitSetsByUserId.entrySet()) {
            String userId = entry.getKey();
            BitSet bitSet = entry.getValue();
            sb.append(userId);
            for (int i = 0; i < bitSet.length(); ++i) {
                if (i % 5 == 0) {
                    sb.append("|");
                }
                sb.append(bitSet.get(i) ? (char)'1' : '0');
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

