/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import java.math.BigDecimal;

public class Apdex {
    private static final String APDEX_FORMAT = "%s [%s]";
    private static final String APDEX_FORMAT_LOW_SAMPLE = "%s [%s]*";
    private static final String APDEX_FORMAT_NO_SAMPLE = "NS [%s]";
    private final BigDecimal threshold;
    private final long numberOfSamples;
    private final BigDecimal apdex;
    private final String longApdex;

    public Apdex(BigDecimal apdex, BigDecimal threshold, long numberOfSamples) {
        this.apdex = apdex;
        this.threshold = threshold;
        this.numberOfSamples = numberOfSamples;
        this.longApdex = this.formatLongApdex();
    }

    public BigDecimal getValue() {
        return this.apdex;
    }

    public String getLongValue() {
        return this.longApdex;
    }

    public BigDecimal getThreshold() {
        return this.threshold;
    }

    public long getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public boolean isLowSample() {
        return this.numberOfSamples < 100L;
    }

    public String toString() {
        return this.longApdex;
    }

    private String formatLongApdex() {
        String s = this.numberOfSamples == 0L ? String.format(APDEX_FORMAT_NO_SAMPLE, this.threshold.toPlainString()) : (this.isLowSample() ? String.format(APDEX_FORMAT_LOW_SAMPLE, this.apdex.toPlainString(), this.threshold.toPlainString()) : String.format(APDEX_FORMAT, this.apdex.toPlainString(), this.threshold.toPlainString()));
        return s;
    }
}

