/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.scorecard;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xceptance.xlt.report.scorecard.TestFailTrigger;
import com.xceptance.xlt.report.scorecard.ValidationException;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@XStreamAlias(value="rule")
public class RuleDefinition {
    @XStreamAsAttribute
    private final String id;
    @XStreamAsAttribute
    private final String name;
    @XStreamAsAttribute
    private boolean enabled = true;
    private String description;
    @XStreamAsAttribute
    private boolean failsTest;
    @XStreamAsAttribute
    private TestFailTrigger failsOn;
    @XStreamAsAttribute
    private boolean negateResult;
    private final Check[] checks;
    @XStreamAsAttribute
    private int points;
    private String successMessage;
    private String failMessage;

    public RuleDefinition(String id, String name, Check[] checks) {
        this.id = Objects.requireNonNull(id, "Rule ID must not be null");
        this.name = name;
        this.checks = Objects.requireNonNull(checks, "Rule checks must not be null");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isFailsTest() {
        return this.failsTest;
    }

    public void setFailsTest(boolean failsTest) {
        this.failsTest = failsTest;
    }

    public TestFailTrigger getFailsOn() {
        return this.failsOn;
    }

    public void setFailsOn(TestFailTrigger failsOn) {
        this.failsOn = failsOn;
    }

    public boolean isNegateResult() {
        return this.negateResult;
    }

    public void setNegateResult(boolean negateResult) {
        this.negateResult = negateResult;
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    public void setFailMessage(String failMessage) {
        this.failMessage = failMessage;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Check[] getChecks() {
        return this.checks;
    }

    static RuleDefinition fromJSON(JSONObject jsonObject) throws ValidationException {
        String ruleId = jsonObject.getString("id");
        String ruleName = StringUtils.trimToNull((String)jsonObject.optString("name"));
        String ruleDesc = jsonObject.optString("description", null);
        boolean enabled = jsonObject.optBoolean("enabled", true);
        boolean failsTest = jsonObject.optBoolean("failsTest", false);
        boolean negateResult = jsonObject.optBoolean("negateResult", false);
        JSONObject messages = jsonObject.optJSONObject("messages");
        JSONArray checks = jsonObject.optJSONArray("checks");
        int rulePoints = jsonObject.optInt("points");
        String failsOnStr = StringUtils.trimToNull((String)jsonObject.optString("failsOn"));
        TestFailTrigger failsOn = (TestFailTrigger)EnumUtils.getEnumIgnoreCase(TestFailTrigger.class, (String)failsOnStr);
        LinkedList<Check> checkList = new LinkedList<Check>();
        if (checks != null) {
            for (int i = 0; i < checks.length(); ++i) {
                JSONObject checkObj = checks.getJSONObject(i);
                String selector = checkObj.optString("selector", null);
                String selectorId = checkObj.optString("selectorId", null);
                String condition = checkObj.getString("condition");
                boolean displayValue = checkObj.optBoolean("displayValue", true);
                boolean checkEnabled = checkObj.optBoolean("enabled", true);
                if (!(selector == null ^ selectorId == null)) {
                    throw new ValidationException("Check #" + i + " is ambiguous: either 'selector' or 'selectorId' property must be given");
                }
                checkList.add(new Check(i, selector, selectorId, condition, checkEnabled, displayValue));
            }
        }
        if (rulePoints < 0) {
            throw new ValidationException("Property 'points' must be a non-negative integer");
        }
        if (!checkList.isEmpty() && !checkList.stream().anyMatch(Check::isEnabled)) {
            throw new ValidationException("Property 'checks' must contain at least one enabled check definition");
        }
        RuleDefinition ruleDef = new RuleDefinition(ruleId, ruleName, (Check[])checkList.toArray(Check[]::new));
        ruleDef.setDescription(ruleDesc);
        ruleDef.setEnabled(enabled);
        ruleDef.setFailsTest(failsTest);
        ruleDef.setFailsOn(failsOn);
        ruleDef.setNegateResult(negateResult);
        ruleDef.setPoints(rulePoints);
        ruleDef.setSuccessMessage(messages != null ? StringUtils.trimToNull((String)messages.optString("success")) : null);
        ruleDef.setFailMessage(messages != null ? StringUtils.trimToNull((String)messages.optString("fail")) : null);
        return ruleDef;
    }

    @XStreamAlias(value="check")
    public static class Check {
        @XStreamAsAttribute
        private final int index;
        private final String selector;
        @XStreamConverter(value=SelectorIdConverter.class)
        @XStreamAlias(value="selector")
        private final String selectorId;
        private final String condition;
        @XStreamAsAttribute
        private final boolean enabled;
        @XStreamAsAttribute
        private final boolean displayValue;

        public Check(int index, String selector, String selectorId, String condition, boolean enabled, boolean displayValue) {
            this.index = Math.max(0, index);
            this.selectorId = selectorId;
            this.selector = selector;
            this.condition = Objects.requireNonNull(condition, "Rule check condition must not be null");
            this.enabled = enabled;
            this.displayValue = displayValue;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDisplayValue() {
            return this.displayValue;
        }

        public String getSelector() {
            return this.selector;
        }

        public String getSelectorId() {
            return this.selectorId;
        }

        public String getCondition() {
            return this.condition;
        }
    }

    public static class SelectorIdConverter
    implements Converter {
        public boolean canConvert(Class type) {
            return type == String.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            writer.addAttribute("ref-id", Objects.toString(source));
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return null;
        }
    }
}

