/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.scorecard;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.xceptance.xlt.report.scorecard.ValidationException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

@XStreamAlias(value="rating")
public class RatingDefinition {
    @XStreamAsAttribute
    private final String id;
    @XStreamAsAttribute
    private final String name;
    private final String description;
    @XStreamAsAttribute
    private final double value;
    @XStreamAsAttribute
    private final boolean enabled;
    @XStreamAsAttribute
    private final boolean failsTest;

    RatingDefinition(String id, String name, String description, double value, boolean enabled, boolean failsTest) {
        this.id = Objects.requireNonNull(id, "Rating ID must not be null");
        this.name = name;
        this.value = value;
        this.description = description;
        this.enabled = enabled;
        this.failsTest = failsTest;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public double getValue() {
        return this.value;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isFailsTest() {
        return this.failsTest;
    }

    static RatingDefinition fromJSON(JSONObject jsonObject) throws ValidationException {
        String id = jsonObject.getString("id");
        String name = StringUtils.trimToNull((String)jsonObject.optString("name"));
        String desc = jsonObject.optString("description", null);
        double value = jsonObject.getDouble("value");
        boolean enabled = jsonObject.optBoolean("enabled", true);
        boolean failsTest = jsonObject.optBoolean("failsTest", false);
        if (Math.min(Math.max(0.0, value), 100.0) != value) {
            throw new ValidationException("Property 'value' must be greater than or equal to 0.0 and less than or equal to 100.0");
        }
        return new RatingDefinition(id, name, desc, value, enabled, failsTest);
    }
}

