/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.scorecard;

import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import com.xceptance.xlt.report.scorecard.GroupDefinition;
import com.xceptance.xlt.report.scorecard.RatingDefinition;
import com.xceptance.xlt.report.scorecard.RuleDefinition;
import com.xceptance.xlt.report.scorecard.SelectorDefinition;
import com.xceptance.xlt.report.scorecard.ValidationException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Configuration {
    @XStreamAsAttribute
    private final int version;
    @XStreamConverter(value=MappedValuesConverter.class)
    private final Map<String, SelectorDefinition> selectors = new LinkedHashMap<String, SelectorDefinition>();
    @XStreamConverter(value=MappedValuesConverter.class)
    private final Map<String, RuleDefinition> rules = new LinkedHashMap<String, RuleDefinition>();
    @XStreamConverter(value=MappedValuesConverter.class)
    private final Map<String, GroupDefinition> groups = new LinkedHashMap<String, GroupDefinition>();
    @XStreamConverter(value=MappedValuesConverter.class)
    private final Map<String, RatingDefinition> ratings = new LinkedHashMap<String, RatingDefinition>();

    public Configuration(int version) {
        this.version = Math.max(1, version);
    }

    public void addSelector(SelectorDefinition selector) throws ValidationException {
        String selectorId = selector.getId();
        this.validateId(selectorId);
        this.selectors.put(selectorId, selector);
    }

    public boolean containsSelector(String selectorId) {
        return this.selectors.containsKey(selectorId);
    }

    public SelectorDefinition getSelector(String selectorId) {
        return this.selectors.get(selectorId);
    }

    public Collection<SelectorDefinition> getSelectors() {
        return Collections.unmodifiableCollection(this.selectors.values());
    }

    void addRule(RuleDefinition rule) throws ValidationException {
        String ruleId = rule.getId();
        this.validateId(ruleId);
        List unknownSelectors = Stream.of(rule.getChecks()).map(RuleDefinition.Check::getSelectorId).filter(Objects::nonNull).filter(Predicate.not(this::containsSelector)).collect(Collectors.toList());
        if (!unknownSelectors.isEmpty()) {
            throw new ValidationException(String.format("Rule '%s' references unknown selector%s: %s", ruleId, unknownSelectors.size() > 1 ? "s" : "", StringUtils.join((Object[])new List[]{unknownSelectors})));
        }
        this.rules.put(ruleId, rule);
    }

    public boolean containsRule(String ruleId) {
        return this.rules.containsKey(ruleId);
    }

    public Collection<RuleDefinition> getRules() {
        return Collections.unmodifiableCollection(this.rules.values());
    }

    public RuleDefinition getRule(String ruleId) {
        return this.rules.get(ruleId);
    }

    void addGroup(GroupDefinition group) throws ValidationException {
        String groupId = group.getId();
        this.validateId(groupId);
        List unknownRules = group.getRuleIds().stream().filter(Predicate.not(this::containsRule)).collect(Collectors.toList());
        if (!unknownRules.isEmpty()) {
            throw new ValidationException(String.format("Group '%s' references unknown rule%s: %s", groupId, unknownRules.size() > 1 ? "s" : "", StringUtils.join((Object[])new List[]{unknownRules})));
        }
        this.groups.put(groupId, group);
    }

    public boolean containsGroup(String groupId) {
        return this.groups.containsKey(groupId);
    }

    public GroupDefinition getGroup(String groupId) {
        return this.groups.get(groupId);
    }

    public Collection<GroupDefinition> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    void addRating(RatingDefinition rating) throws ValidationException {
        String ratingId = rating.getId();
        this.validateId(ratingId);
        this.ratings.put(ratingId, rating);
    }

    public boolean containsRating(String ratingId) {
        return this.ratings.containsKey(ratingId);
    }

    public RatingDefinition getRating(String ratingId) {
        return this.ratings.get(ratingId);
    }

    public Collection<RatingDefinition> getRatings() {
        return Collections.unmodifiableCollection(this.ratings.values());
    }

    public int getVersion() {
        return this.version;
    }

    private void validateId(String id) throws ValidationException {
        String ambigousUDErrorMsg = "Some other %s shares the same ID: '%s'. IDs must be unique.";
        if (this.containsSelector(id)) {
            throw new ValidationException(String.format("Some other %s shares the same ID: '%s'. IDs must be unique.", "selector", id));
        }
        if (this.containsRule(id)) {
            throw new ValidationException(String.format("Some other %s shares the same ID: '%s'. IDs must be unique.", "rule", id));
        }
        if (this.containsGroup(id)) {
            throw new ValidationException(String.format("Some other %s shares the same ID: '%s'. IDs must be unique.", "group", id));
        }
        if (this.containsRating(id)) {
            throw new ValidationException(String.format("Some other %s shares the same ID: '%s'. IDs must be unique.", "rating", id));
        }
    }

    static Configuration fromJSON(JSONObject jsonObject) throws ValidationException {
        JSONArray ruleArr;
        Configuration config = new Configuration(jsonObject.optInt("version", -1));
        JSONArray selectorArr = jsonObject.optJSONArray("selectors");
        if (selectorArr != null) {
            for (int i = 0; i < selectorArr.length(); ++i) {
                try {
                    SelectorDefinition selDef = SelectorDefinition.fromJSON(selectorArr.getJSONObject(i));
                    config.addSelector(selDef);
                    continue;
                }
                catch (Exception e) {
                    throw new ValidationException(String.format("Selector #%d is invalid: %s", i, e.getMessage()));
                }
            }
        }
        if ((ruleArr = jsonObject.optJSONArray("rules")) != null) {
            for (int i = 0; i < ruleArr.length(); ++i) {
                try {
                    RuleDefinition ruleDef = RuleDefinition.fromJSON(ruleArr.getJSONObject(i));
                    config.addRule(ruleDef);
                    continue;
                }
                catch (Exception e) {
                    throw new ValidationException(String.format("Rule #%d is invalid: %s", i, e.getMessage()));
                }
            }
        }
        JSONArray groupArr = jsonObject.getJSONArray("groups");
        for (int i = 0; i < groupArr.length(); ++i) {
            try {
                GroupDefinition groupDef2 = GroupDefinition.fromJSON(groupArr.getJSONObject(i));
                config.addGroup(groupDef2);
                continue;
            }
            catch (Exception e) {
                throw new ValidationException(String.format("Group #%d is invalid: %s", i, e.getMessage()));
            }
        }
        JSONArray ratingArr = jsonObject.optJSONArray("ratings");
        if (ratingArr != null) {
            for (int i = 0; i < ratingArr.length(); ++i) {
                try {
                    RatingDefinition ratingDef = RatingDefinition.fromJSON(ratingArr.getJSONObject(i));
                    config.addRating(ratingDef);
                    continue;
                }
                catch (Exception e) {
                    throw new ValidationException(String.format("Rating #%d is invalid: %s", i, e.getMessage()));
                }
            }
        }
        if (!config.rules.values().stream().anyMatch(RuleDefinition::isEnabled)) {
            throw new ValidationException("Configuration must contain at least one enabled rule");
        }
        if (!config.groups.values().stream().anyMatch(groupDef -> groupDef.isEnabled() && !groupDef.getRuleIds().isEmpty())) {
            throw new ValidationException("Configuration must contain at least one enabled and non-empty group");
        }
        return config;
    }

    public static class MappedValuesConverter
    extends MapConverter {
        public MappedValuesConverter(Mapper mapper, Class<?> type) {
            super(mapper, type);
        }

        public MappedValuesConverter(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class type) {
            if (Map.class.isAssignableFrom(type)) {
                return true;
            }
            return super.canConvert(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Map m = (Map)source;
            for (Object o : m.values()) {
                this.writeCompleteItem(o, context, writer);
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return null;
        }
    }
}

