/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.common.collection.FastHashMap;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.util.XltCharBuffer;
import com.xceptance.xlt.report.providers.IpReport;
import com.xceptance.xlt.report.providers.IpsReport;
import java.util.ArrayList;

public class IpReportProvider
extends AbstractReportProvider {
    private static final XltCharBuffer UNKNOWN_IP = XltCharBuffer.valueOf("(unknown)");
    private final FastHashMap<XltCharBuffer, IpReport> ipReports = new FastHashMap();

    @Override
    public Object createReportFragment() {
        IpsReport report = new IpsReport();
        report.ips = new ArrayList<IpReport>(this.ipReports.values());
        return report;
    }

    @Override
    public void processDataRecord(Data data) {
        if (data instanceof RequestData) {
            RequestData reqData = (RequestData)data;
            XltCharBuffer hostName = reqData.getHost();
            XltCharBuffer ip = reqData.getUsedIpAddress();
            if (ip == null || ip.length() == 0) {
                ip = UNKNOWN_IP;
            }
            this.updateIpCount(ip, hostName);
        }
    }

    private void updateIpCount(XltCharBuffer ip, XltCharBuffer host) {
        XltCharBuffer key = XltCharBuffer.valueOf(ip, host);
        IpReport ipReport = this.ipReports.get(key);
        if (ipReport == null) {
            ipReport = new IpReport();
            ipReport.ip = ip.toString();
            ipReport.host = host.toString();
            this.ipReports.put(key, ipReport);
        }
        ++ipReport.count;
    }
}

