/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.common.collection.FastHashMap;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.EventData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.report.ReportProviderConfiguration;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.providers.EventReport;
import com.xceptance.xlt.report.providers.EventsReport;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.TaskManager;
import com.xceptance.xlt.report.util.ValueSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class EventsReportProvider
extends AbstractReportProvider {
    private static final String XLT_INTERNAL_TESTCASE = "XLT Internal";
    private static final String IGNORE_TESTCASE = "<ignored>";
    private final ValueSet eventsPerSecondValueSet = new ValueSet();
    private final FastHashMap<String, Map<String, EventReport>> testCaseToEventMap = new FastHashMap(23, 0.5f);
    private boolean groupEventsByTestCase = true;
    private int eventsDropped;
    private int messageLimit = 100;
    private int eventLimitPerTestCase = 100;

    @Override
    public void setConfiguration(ReportProviderConfiguration config) {
        super.setConfiguration(config);
        this.groupEventsByTestCase = ((ReportGeneratorConfiguration)config).getGroupEventsByTestCase();
        this.messageLimit = ((ReportGeneratorConfiguration)config).getEventMessageLimitPerEvent();
        this.eventLimitPerTestCase = ((ReportGeneratorConfiguration)config).getEventLimitPerTestCase();
    }

    @Override
    public void processDataRecord(Data data) {
        if (!(data instanceof EventData)) {
            return;
        }
        this.eventsPerSecondValueSet.addOrUpdateValue(data.getTime(), 1);
        if (this.eventLimitPerTestCase <= 0) {
            ++this.eventsDropped;
            return;
        }
        EventData eventData = (EventData)data;
        String testCaseName = this.groupEventsByTestCase ? eventData.getTestCaseName() : IGNORE_TESTCASE;
        Map<String, EventReport> stat = this.testCaseToEventMap.get(testCaseName);
        if (stat == null) {
            EventReport eventReport = new EventReport(testCaseName, eventData.getName());
            eventReport.addMessage(eventData.getMessage(), this.messageLimit);
            stat = new HashMap<String, EventReport>();
            stat.put(eventData.getName(), eventReport);
            this.testCaseToEventMap.put(testCaseName, stat);
        } else {
            EventReport eventReport = stat.get(eventData.getName());
            if (eventReport == null) {
                if (stat.size() >= this.eventLimitPerTestCase) {
                    ++this.eventsDropped;
                } else {
                    eventReport = new EventReport(testCaseName, eventData.getName());
                    eventReport.addMessage(eventData.getMessage(), this.messageLimit);
                    stat.put(eventData.getName(), eventReport);
                }
            } else {
                eventReport.addMessage(eventData.getMessage(), this.messageLimit);
            }
        }
    }

    @Override
    public Object createReportFragment() {
        if (this.getConfiguration().shouldChartsGenerated()) {
            TaskManager taskManager = TaskManager.getInstance();
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    int minMaxValueSetSize = EventsReportProvider.this.getConfiguration().getChartWidth();
                    TimeSeries eventsPerSecondTimeSeries = JFreeChartUtils.toStandardTimeSeries(EventsReportProvider.this.eventsPerSecondValueSet.toMinMaxValueSet(minMaxValueSetSize), "Events/s");
                    EventsReportProvider.this.createEventChart(eventsPerSecondTimeSeries);
                }
            });
        }
        ArrayList<EventReport> eventReports = new ArrayList<EventReport>();
        this.testCaseToEventMap.values().forEach(e -> eventReports.addAll(e.values()));
        eventReports.forEach(EventReport::prepareSerialization);
        if (this.eventsDropped > 0) {
            EventReport dropped = new EventReport(XLT_INTERNAL_TESTCASE, ">> XLT::EventsDropped - Reached event limit <<");
            dropped.totalCount = this.eventsDropped;
            dropped.droppedCount = 0;
            eventReports.add(dropped);
        }
        EventsReport eventsReport = new EventsReport();
        eventsReport.events = eventReports;
        return eventsReport;
    }

    private void createEventChart(TimeSeries eventsPerSecondTimeSeries) {
        TimeSeriesCollection events = new TimeSeriesCollection(eventsPerSecondTimeSeries);
        ReportProviderConfiguration config = this.getConfiguration();
        JFreeChart chart = JFreeChartUtils.createBarChart("Events", (XYDataset)events, "Events", JFreeChartUtils.COLOR_EVENT, config.getChartStartTime(), config.getChartEndTime());
        JFreeChartUtils.saveChart(chart, "Events", config.getChartDirectory(), config.getChartWidth(), config.getChartHeight());
    }
}

