/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.CustomValue;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.providers.AbstractDataProcessor;
import com.xceptance.xlt.report.providers.CustomValueReport;
import com.xceptance.xlt.report.util.DoubleMinMaxValueSet;
import com.xceptance.xlt.report.util.DoubleSummaryStatistics;
import com.xceptance.xlt.report.util.FixedSizeHistogramDoubleValueSet;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.ReportUtils;
import com.xceptance.xlt.report.util.TaskManager;
import com.xceptance.xlt.util.PropertyHierarchy;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.math3.stat.descriptive.rank.PSquarePercentile;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.xy.XYIntervalSeries;

public class CustomValueProcessor
extends AbstractDataProcessor {
    private final String CUSTOM_SAMPLER_DOMAIN = "com.xceptance.xlt.customSamplers";
    private final DoubleMinMaxValueSet vSet = new DoubleMinMaxValueSet();
    private final DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
    private final PSquarePercentile median = new PSquarePercentile(50.0);
    private final FixedSizeHistogramDoubleValueSet histogram;
    private final Map<Double, PSquarePercentile> percentiles = new LinkedHashMap<Double, PSquarePercentile>();

    public CustomValueProcessor(String name, AbstractReportProvider reportProvider) {
        super(name, reportProvider);
        double[] p;
        this.setChartDir(new File(this.getChartDir(), "customvalues"));
        this.histogram = new FixedSizeHistogramDoubleValueSet(this.getChartHeight());
        for (double d : p = ((ReportGeneratorConfiguration)this.getConfiguration()).getRuntimePercentiles()) {
            this.percentiles.put(d, new PSquarePercentile(d));
        }
    }

    @Override
    public void processDataRecord(Data data) {
        CustomValue sample = (CustomValue)data;
        double value = sample.getValue();
        this.vSet.addOrUpdateValue(sample.getTime(), value);
        this.stats.addValue(value);
        this.median.increment(value);
        this.histogram.addValue(value);
        for (PSquarePercentile percentile : this.percentiles.values()) {
            percentile.increment(value);
        }
    }

    public CustomValueReport createReportFragment() {
        CustomValueReport reportFragment = null;
        String seriesName = this.getName();
        PropertyHierarchy propH = new PropertyHierarchy("com.xceptance.xlt.customSamplers");
        propH.set(XltProperties.getInstance().getPropertiesForKey("com.xceptance.xlt.customSamplers"));
        Set<String> samplerKeys = propH.getChildKeyFragments();
        for (String samplerKey : samplerKeys) {
            String samplerName;
            PropertyHierarchy samplerConfig = propH.get(samplerKey);
            if (samplerConfig == null || (samplerName = samplerConfig.getKeyValue("name")) == null || !samplerName.equals(seriesName)) continue;
            String description = samplerConfig.getKeyValue("description");
            String chartTitle = seriesName;
            String yAxisTitle = "Value";
            PropertyHierarchy chartConfig = samplerConfig.get("chart");
            if (chartConfig != null) {
                chartTitle = (String)ObjectUtils.defaultIfNull((Object)chartConfig.getKeyValue("title"), (Object)chartTitle);
                yAxisTitle = (String)ObjectUtils.defaultIfNull((Object)chartConfig.getKeyValue("yAxisTitle"), (Object)yAxisTitle);
            }
            reportFragment = this.createReportFragment(seriesName, chartTitle, description, yAxisTitle);
            break;
        }
        if (reportFragment == null) {
            reportFragment = this.createReportFragment(seriesName, seriesName, "", "Value");
        }
        return reportFragment;
    }

    private CustomValueReport createReportFragment(final String samplerName, final String chartTitle, String description, final String yAxisTitle) {
        final String chartFileName = UUID.randomUUID().toString();
        if (this.getConfiguration().shouldChartsGenerated()) {
            final TimeSeries valueSeries = JFreeChartUtils.toMinMaxTimeSeries(this.vSet, samplerName);
            final TimeSeries averageValueSeries = JFreeChartUtils.createMovingAverageTimeSeries(valueSeries, this.getMovingAveragePercentage());
            final XYIntervalSeries histogramSeries = this.histogram.toSeries("Counts");
            TaskManager taskManager = TaskManager.getInstance();
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    CustomValueProcessor.this.createCustomValueChart(samplerName, chartTitle, yAxisTitle, chartFileName, valueSeries, averageValueSeries, histogramSeries, -1);
                }
            });
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    CustomValueProcessor.this.createCustomValueAverageChart(samplerName, chartTitle, yAxisTitle, chartFileName, valueSeries, averageValueSeries, CustomValueProcessor.this.median.getResult(), CustomValueProcessor.this.stats.getMean());
                }
            });
        }
        CustomValueReport reportFragment = new CustomValueReport();
        reportFragment.name = samplerName;
        reportFragment.description = description;
        reportFragment.min = ReportUtils.convertToBigDecimal(this.stats.getMinimum());
        reportFragment.mean = ReportUtils.convertToBigDecimal(this.stats.getMean());
        reportFragment.max = ReportUtils.convertToBigDecimal(this.stats.getMaximum());
        reportFragment.standardDeviation = ReportUtils.convertToBigDecimal(this.stats.getStandardDeviation());
        reportFragment.chartFilename = chartFileName;
        double count = this.stats.getCount();
        long duration = Math.max((this.getEndTime() - this.getStartTime()) / 1000L, 1L);
        reportFragment.count = (int)count;
        reportFragment.countPerSecond = ReportUtils.convertToBigDecimal(count / (double)duration);
        reportFragment.countPerMinute = ReportUtils.convertToBigDecimal(count * 60.0 / (double)duration);
        reportFragment.countPerHour = ReportUtils.convertToBigDecimal(count * 3600.0 / (double)duration);
        reportFragment.countPerDay = ReportUtils.convertToBigDecimal(count * 86400.0 / (double)duration);
        for (Map.Entry<Double, PSquarePercentile> percentileEntry : this.percentiles.entrySet()) {
            double p = percentileEntry.getKey();
            double res = percentileEntry.getValue().getResult();
            reportFragment.percentiles.put("p" + ReportUtils.formatValue(p), ReportUtils.convertToBigDecimal(res));
        }
        return reportFragment;
    }

    private void createCustomValueChart(String samplerName, String chartTitle, String yAxisTitle, String chartFileName, TimeSeries timeSeries, TimeSeries averageTimeSeries, XYIntervalSeries histogramSeries, int chartCappingValue) {
        ReportGeneratorConfiguration.ChartScale chartScale = ((ReportGeneratorConfiguration)this.getConfiguration()).getChartScale();
        DateAxis timeAxis = JFreeChartUtils.createTimeAxis(this.getStartTime(), this.getEndTime());
        XYPlot customValuePlot = JFreeChartUtils.createLinePlot(timeSeries, averageTimeSeries, (ValueAxis)timeAxis, yAxisTitle, true, chartScale, chartCappingValue);
        NumberAxis rangeAxis = (NumberAxis)customValuePlot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits());
        Range valueRange = customValuePlot.getRangeAxis().getRange();
        XYPlot histogramPlot = JFreeChartUtils.createHistogramPlot(histogramSeries, valueRange, chartScale, chartCappingValue);
        CombinedRangeXYPlot combinedPlot = new CombinedRangeXYPlot();
        combinedPlot.setGap(4.0);
        combinedPlot.setRangeAxis((ValueAxis)rangeAxis);
        combinedPlot.add(customValuePlot, 15);
        combinedPlot.add(histogramPlot, 1);
        JFreeChart chart = JFreeChartUtils.createChart(chartTitle, (Plot)combinedPlot);
        JFreeChartUtils.saveChart(chart, chartFileName, this.getChartDir(), this.getChartWidth(), this.getChartHeight());
    }

    private void createCustomValueAverageChart(String name, String chartTitle, String yAxisTitle, String chartFileName, TimeSeries valueSeries, TimeSeries averageValueSeries, double median, double mean) {
        JFreeChart chart = JFreeChartUtils.createAverageLineChart(name, chartTitle, yAxisTitle, valueSeries, averageValueSeries, median, mean, this.getStartTime(), this.getEndTime());
        chart.getXYPlot().getRangeAxis().setStandardTickUnits(NumberAxis.createStandardTickUnits());
        JFreeChartUtils.saveChart(chart, chartFileName + "_Average", this.getChartDir(), this.getChartWidth(), this.getChartHeight());
    }
}

