/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.common.collection.FastHashMap;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.report.providers.AbstractDataProcessor;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractDataProcessorBasedReportProvider<T extends AbstractDataProcessor>
extends AbstractReportProvider {
    private final Class<T> implClass;
    private final FastHashMap<String, T> processors = new FastHashMap(11, 0.5f);

    protected AbstractDataProcessorBasedReportProvider(Class<T> c) {
        this.implClass = c;
    }

    @Override
    public void processDataRecord(Data stat) {
        T processor = this.getProcessor(stat.getName());
        ((AbstractDataProcessor)processor).processDataRecord(stat);
    }

    protected T getProcessor(String name) {
        AbstractDataProcessor processor = (AbstractDataProcessor)this.processors.get(name);
        if (processor == null) {
            try {
                Constructor<T> constructor = this.implClass.getConstructor(String.class, AbstractReportProvider.class);
                processor = (AbstractDataProcessor)constructor.newInstance(name, this);
            }
            catch (Exception ex) {
                throw new RuntimeException("", ex);
            }
            this.processors.put(name, processor);
        }
        return (T)processor;
    }

    protected Collection<T> getProcessors() {
        List<String> keys = this.processors.keys();
        Collections.sort(keys);
        ArrayList<AbstractDataProcessor> values = new ArrayList<AbstractDataProcessor>();
        for (String k : keys) {
            values.add((AbstractDataProcessor)this.processors.get(k));
        }
        return Collections.unmodifiableCollection(values);
    }
}

