/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.external.config;

import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.report.external.config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class ExternalDataConfigProvider {
    private static final String CONFIG_FILE = "externaldataconfig";
    private static final String CONFIG_FILE_SCHEMA = "externaldataconfig.xsd";
    private static final String CONFIG_FILE_NAME = "externaldataconfig.xml";

    private ExternalDataConfigProvider() {
    }

    public static Config getConfig(String inputDir) throws FileNotFoundException, JAXBException, SAXException {
        File configFile = ExternalDataConfigProvider.getConfigFile(inputDir);
        Config config = ExternalDataConfigProvider.loadConfigFile(configFile);
        return config;
    }

    private static File getConfigFile(String inputDir) {
        File[] dirs;
        for (File dir : dirs = new File[]{new File(inputDir, "config"), new File(inputDir), XltExecutionContext.getCurrent().getXltConfigDir()}) {
            File configFile = new File(dir, CONFIG_FILE_NAME);
            if (!configFile.isFile() || !configFile.canRead()) continue;
            return configFile;
        }
        return null;
    }

    private static Config loadConfigFile(File configFile) throws JAXBException, FileNotFoundException, SAXException {
        if (configFile == null) {
            return new Config();
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Config.class});
        Unmarshaller um = context.createUnmarshaller();
        FileInputStream in = new FileInputStream(configFile);
        InputStreamReader reader = new InputStreamReader((InputStream)in, Charset.forName("UTF-8"));
        URL schemaUrl = ExternalDataConfigProvider.class.getResource(CONFIG_FILE_SCHEMA);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaUrl);
        final StringBuilder validationErrors = new StringBuilder();
        ValidationEventHandler validationEventHandler = new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent ve) {
                if (ve.getSeverity() != 0) {
                    ValidationEventLocator vel = ve.getLocator();
                    validationErrors.append("\n-> [" + vel.getLineNumber() + ":" + vel.getColumnNumber() + "] " + ve.getMessage());
                }
                return true;
            }
        };
        um.setSchema(schema);
        um.setEventHandler(validationEventHandler);
        Config config = (Config)um.unmarshal((Reader)reader);
        if (validationErrors.length() > 0) {
            throw new XltException("Errors in config file: " + configFile.getAbsolutePath() + String.valueOf(validationErrors));
        }
        return config;
    }
}

