/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.common.util.SynchronizingCounter;
import com.xceptance.xlt.api.report.PostProcessedDataContainer;
import com.xceptance.xlt.report.DataChunk;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.StatisticsProcessor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;

public class Dispatcher {
    public static final int DEFAULT_QUEUE_CHUNK_SIZE = 200;
    public static final int DEFAULT_QUEUE_LENGTH = 100;
    private final SynchronizingCounter remainingDirectories = new SynchronizingCounter();
    private final AtomicInteger totalDirectories = new AtomicInteger();
    private final SynchronizingCounter openDataChunkCount = new SynchronizingCounter();
    private final BlockingQueue<DataChunk> readDataQueue;
    public final int chunkSize;
    private final ProgressBar progressBar = new ProgressBarBuilder().setTaskName("Reading").setStyle(ProgressBarStyle.ASCII).build();
    private final StatisticsProcessor statisticsProcessor;

    public Dispatcher(ReportGeneratorConfiguration config, StatisticsProcessor statisticsProcessor) {
        this.readDataQueue = new LinkedBlockingQueue<DataChunk>(config.threadQueueLength);
        this.chunkSize = config.threadQueueBucketSize;
        this.statisticsProcessor = statisticsProcessor;
    }

    public void startProgress() {
    }

    public void incremementDirectoryCount() {
        this.totalDirectories.incrementAndGet();
        this.remainingDirectories.increment();
    }

    public void beginReading() throws InterruptedException {
        this.progressBar.maxHint((long)this.totalDirectories.get());
    }

    public void finishedReading() {
        this.remainingDirectories.decrement();
        this.progressBar.maxHint((long)this.totalDirectories.get());
        this.progressBar.step();
    }

    public void addReadData(DataChunk chunkOfLines) throws InterruptedException {
        this.openDataChunkCount.increment();
        this.readDataQueue.put(chunkOfLines);
    }

    public DataChunk retrieveReadData() throws InterruptedException {
        return this.readDataQueue.take();
    }

    public void addPostprocessedData(PostProcessedDataContainer postprocessedData) throws InterruptedException {
        this.statisticsProcessor.process(postprocessedData);
        this.finishedProcessing();
    }

    private void finishedProcessing() {
        this.openDataChunkCount.decrement();
    }

    public void waitForDataRecordProcessingToComplete() throws InterruptedException {
        this.remainingDirectories.awaitZero();
        this.openDataChunkCount.awaitZero();
        this.progressBar.close();
    }

    public int getRemainingDirectoryCount() {
        return this.remainingDirectories.get();
    }

    public int getTotalDirectoryCount() {
        return this.totalDirectories.get();
    }
}

