/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.common.io.XltBufferedLineReader;
import com.xceptance.xlt.api.util.SimpleArrayList;
import com.xceptance.xlt.api.util.XltCharBuffer;
import com.xceptance.xlt.common.XltConstants;
import com.xceptance.xlt.report.DataChunk;
import com.xceptance.xlt.report.Dispatcher;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataReaderThread
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(DataReaderThread.class);
    private final ConcurrentSkipListMap<Long, String> actionNames = new ConcurrentSkipListMap();
    private final String agentName;
    private final FileObject directory;
    private final String testCaseName;
    private final AtomicLong totalLineCounter;
    private final String userNumber;
    private final Dispatcher dispatcher;

    public DataReaderThread(FileObject directory, String agentName, String testCaseName, String userNumber, AtomicLong totalLineCounter, Dispatcher dispatcher) {
        this.directory = directory;
        this.agentName = agentName;
        this.testCaseName = testCaseName;
        this.userNumber = userNumber;
        this.totalLineCounter = totalLineCounter;
        this.dispatcher = dispatcher;
    }

    @Override
    public void run() {
        try {
            this.dispatcher.beginReading();
            this.readLogsFromTestUserDir();
        }
        catch (Exception e) {
            String msg = String.format("Failed to read test results from directory '%s'", this.directory);
            LOG.error(msg, (Throwable)e);
        }
        finally {
            this.dispatcher.finishedReading();
        }
    }

    private void readLogsFromTestUserDir() throws Exception {
        ArrayList<FileObject> regularTimerFiles = new ArrayList<FileObject>();
        ArrayList<FileObject> clientPerformanceTimerFiles = new ArrayList<FileObject>();
        for (FileObject file : this.directory.getChildren()) {
            if (file.getType() != FileType.FILE || !file.isReadable()) continue;
            String fileName = file.getName().getBaseName();
            if (XltConstants.TIMER_FILENAME_PATTERNS.stream().anyMatch(r -> r.asPredicate().test(fileName))) {
                regularTimerFiles.add(file);
                continue;
            }
            if (!XltConstants.CPT_TIMER_FILENAME_PATTERNS.stream().anyMatch(r -> r.asPredicate().test(fileName))) continue;
            clientPerformanceTimerFiles.add(file);
        }
        boolean haveClientPerformanceTimerFiles = !clientPerformanceTimerFiles.isEmpty();
        for (FileObject file : regularTimerFiles) {
            this.readTimerLog(file, haveClientPerformanceTimerFiles, false);
        }
        if (haveClientPerformanceTimerFiles) {
            for (FileObject file : clientPerformanceTimerFiles) {
                this.readTimerLog(file, false, true);
            }
        }
    }

    private void readTimerLog(FileObject file, boolean collectActionNames, boolean adjustTimerName) {
        boolean isCompressed = "gz".equalsIgnoreCase(file.getName().getExtension());
        int chunkSize = this.dispatcher.chunkSize;
        try (XltBufferedLineReader reader = new XltBufferedLineReader(new InputStreamReader(isCompressed ? new GZIPInputStream(file.getContent().getInputStream(), 16384) : file.getContent().getInputStream(), "UTF-8"));){
            DataChunk lineChunk;
            XltCharBuffer line;
            SimpleArrayList<XltCharBuffer> lines = new SimpleArrayList<XltCharBuffer>(chunkSize);
            int baseLineNumber = 1;
            int linesRead = 0;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
                if (++linesRead != chunkSize) continue;
                lineChunk = new DataChunk(lines, baseLineNumber, file, this.agentName, this.testCaseName, this.userNumber, collectActionNames, adjustTimerName, this.actionNames);
                this.dispatcher.addReadData(lineChunk);
                lines = new SimpleArrayList(chunkSize);
                baseLineNumber += linesRead;
                this.totalLineCounter.addAndGet(linesRead);
                linesRead = 0;
            }
            if (linesRead > 0) {
                lineChunk = new DataChunk(lines, baseLineNumber, file, this.agentName, this.testCaseName, this.userNumber, collectActionNames, adjustTimerName, this.actionNames);
                this.dispatcher.addReadData(lineChunk);
                this.totalLineCounter.addAndGet(linesRead);
            }
        }
        catch (Exception ex) {
            LOG.error(String.format("Failed to read timer input file '%s'", file), (Throwable)ex);
        }
    }
}

