/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import java.util.ArrayList;

public final class LoadFunctionUtils {
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_MINUTE = 60L;

    private LoadFunctionUtils() {
    }

    public static boolean isComplexLoadFunction(int[][] timeValuePairs) {
        return !LoadFunctionUtils.isSimpleLoadFunction(timeValuePairs);
    }

    public static boolean isSimpleLoadFunction(int[][] timeValuePairs) {
        return timeValuePairs.length == 1 && timeValuePairs[0][0] == 0;
    }

    public static void checkLoadFunction(int[][] timeValuePairs) throws IllegalArgumentException {
        if (timeValuePairs.length == 0) {
            throw new IllegalArgumentException("The function does not specify any time/value pairs.");
        }
        int lastT = 0;
        for (int i = 0; i < timeValuePairs.length; ++i) {
            int t = timeValuePairs[i][0];
            int v = timeValuePairs[i][1];
            if (t < 0 || v < 0) {
                throw new IllegalArgumentException("Either time or value is negative.");
            }
            if (t < lastT) {
                throw new IllegalArgumentException("The time/value pairs must be sorted in ascending order.");
            }
            lastT = t;
        }
    }

    public static int[][] completeLoadFunctionIfNecessary(int[][] timeValuePairs) {
        int firstTime = timeValuePairs[0][0];
        if (firstTime > 0) {
            int[][] completedTimeValuePairs = new int[timeValuePairs.length + 1][];
            completedTimeValuePairs[0] = new int[]{0, 1};
            System.arraycopy(timeValuePairs, 0, completedTimeValuePairs, 1, timeValuePairs.length);
            return completedTimeValuePairs;
        }
        return timeValuePairs;
    }

    public static int[][] computeLoadFunction(int rampUpInitialValue, int rampUpTargetValue, int rampUpPeriod, int rampUpStepSize, int rampUpSteadyPeriod) {
        double steadyPeriod;
        int period;
        if (rampUpTargetValue < 0) {
            throw new IllegalArgumentException("Ramp-up target value is not specified.");
        }
        if (rampUpPeriod >= 0 && rampUpSteadyPeriod >= 0) {
            throw new IllegalArgumentException("Both ramp-up period and ramp-up steady period are given, but they are mutually exclusive.");
        }
        int targetValue = rampUpTargetValue;
        int stepSize = rampUpStepSize <= 0 ? 1 : rampUpStepSize;
        int initialValue = rampUpInitialValue < 0 ? stepSize : rampUpInitialValue;
        int steps = initialValue < targetValue ? (int)Math.ceil((double)(targetValue - initialValue) / (double)stepSize) : 0;
        if (rampUpPeriod <= 0 && rampUpSteadyPeriod <= 0 || steps == 0) {
            period = 0;
            steadyPeriod = 0.0;
        } else if (rampUpPeriod > 0) {
            period = rampUpPeriod;
            steadyPeriod = (double)period / (double)steps;
        } else {
            period = rampUpSteadyPeriod * steps;
            steadyPeriod = rampUpSteadyPeriod;
        }
        if (period == 0) {
            return new int[][]{{0, targetValue}};
        }
        if (stepSize == 1) {
            return new int[][]{{0, initialValue}, {period, targetValue}};
        }
        ArrayList<int[]> loadFunction = new ArrayList<int[]>();
        loadFunction.add(new int[]{0, initialValue});
        int lastValue = initialValue;
        for (int elapsedTime = 1; elapsedTime <= period; ++elapsedTime) {
            int numSteadyPeriods = (int)((double)elapsedTime / steadyPeriod);
            int value = Math.min(targetValue, initialValue + numSteadyPeriods * stepSize);
            if (value <= lastValue) continue;
            loadFunction.add(new int[]{elapsedTime, lastValue});
            loadFunction.add(new int[]{elapsedTime, value});
            lastValue = value;
        }
        return (int[][])loadFunction.toArray((T[])new int[loadFunction.size()][2]);
    }

    public static String loadFunctionToString(int[][] loadFunction) {
        if (loadFunction.length == 0) {
            return "";
        }
        if (loadFunction.length == 1 && loadFunction[0][0] == 0) {
            return String.valueOf(loadFunction[0][1]);
        }
        return LoadFunctionUtils.multiPairLoadFunctionToString(loadFunction);
    }

    private static String multiPairLoadFunctionToString(int[][] loadFunction) {
        StringBuilder returnValue = new StringBuilder();
        for (int i = 0; i < loadFunction.length; ++i) {
            int[] pair = loadFunction[i];
            int timeInSeconds = pair[0];
            int value = pair[1];
            if (timeInSeconds == 0) {
                returnValue.append("0s");
            } else {
                if ((long)timeInSeconds >= 3600L) {
                    returnValue.append((long)timeInSeconds / 3600L).append('h');
                    timeInSeconds = (int)((long)timeInSeconds % 3600L);
                }
                if ((long)timeInSeconds >= 60L) {
                    returnValue.append((long)timeInSeconds / 60L).append('m');
                    timeInSeconds = (int)((long)timeInSeconds % 60L);
                }
                if (timeInSeconds > 0) {
                    returnValue.append(timeInSeconds).append('s');
                }
            }
            returnValue.append('/').append(value);
            if (i >= loadFunction.length - 1) continue;
            returnValue.append(' ');
        }
        return returnValue.toString();
    }

    public static int[][] scaleLoadFunction(int[][] loadFunction, int[][] loadFactorFunction) {
        Object result;
        if (loadFunction == null || loadFactorFunction == null) {
            result = loadFunction;
        } else if (loadFunction.length == 0 || loadFactorFunction.length == 0) {
            result = loadFunction;
        } else if (LoadFunctionUtils.isComplexLoadFunction(loadFunction) && LoadFunctionUtils.isComplexLoadFunction(loadFactorFunction)) {
            result = loadFunction;
        } else {
            int permill;
            int[][] function;
            if (LoadFunctionUtils.isSimpleLoadFunction(loadFactorFunction)) {
                function = loadFunction;
                permill = loadFactorFunction[0][1];
            } else {
                function = loadFactorFunction;
                permill = loadFunction[0][1];
            }
            result = new int[function.length][];
            for (int i = 0; i < ((int[][])result).length; ++i) {
                int time = function[i][0];
                int value = function[i][1];
                value = (int)Math.ceil((double)value * ((double)permill / 1000.0));
                result[i] = new int[]{time, value};
            }
        }
        return result;
    }
}

