/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.google.cloud.compute.v1.Instance;
import com.google.cloud.compute.v1.Region;
import com.xceptance.xlt.gce.GceAdminUtils;
import com.xceptance.xlt.gce.GceClient;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class OpListInstancesByNameLabelNonInteractively {
    private final GceClient gceClient;

    OpListInstancesByNameLabelNonInteractively(GceClient gceClient) {
        this.gceClient = gceClient;
    }

    void execute(String regionName, String nameLabel, File outputFile) throws IOException {
        try {
            Region region = this.gceClient.getRegion(regionName);
            List<Instance> instances = this.gceClient.getInstancesInRegion(region);
            instances = this.filterInstancesByNameLabel(instances, nameLabel);
            GceAdminUtils.outputAgentControllerConnectionProperties(instances, outputFile);
        }
        catch (Exception e) {
            GceAdminUtils.dieWithMessage(String.format("Failed to list the instances with name label '%s' in region '%s'", nameLabel, regionName), e);
        }
    }

    private List<Instance> filterInstancesByNameLabel(List<Instance> instances, String nameLabel) {
        ArrayList<Instance> filteredInstances = new ArrayList<Instance>();
        for (Instance instance : instances) {
            String instanceNameLabel;
            Map instanceLabels = instance.getLabelsMap();
            if (instanceLabels == null || !nameLabel.equals(instanceNameLabel = (String)instanceLabels.get("name"))) continue;
            filteredInstances.add(instance);
        }
        return filteredInstances;
    }
}

