/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.google.cloud.compute.v1.InstanceTemplate;
import com.google.cloud.compute.v1.Region;
import com.xceptance.common.util.ConsoleUiUtils;
import com.xceptance.xlt.gce.GceAdminUtils;
import com.xceptance.xlt.gce.GceClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class OpCreateInstanceGroup {
    private final GceClient gceClient;

    OpCreateInstanceGroup(GceClient gceClient) {
        this.gceClient = gceClient;
    }

    void execute() throws IOException {
        List<InstanceTemplate> instanceTemplates = this.gceClient.getInstanceTemplates();
        if (instanceTemplates.isEmpty()) {
            System.out.println("To create a managed instance group, an instance template is needed but none was found.");
            return;
        }
        List<Region> regions = this.gceClient.getRegions();
        List<Region> selectedRegions = GceAdminUtils.multiSelectRegions(regions);
        System.out.println();
        InstanceTemplate instanceTemplate = this.selectInstanceTemplate(instanceTemplates);
        System.out.println();
        String instanceGroupName = this.readInstanceGroupName();
        System.out.println();
        int instanceCount = this.readInstanceCount();
        System.out.println();
        StringBuilder sb = new StringBuilder();
        sb.append("  Regions             : ").append(OpCreateInstanceGroup.getRegionNames(selectedRegions)).append("\n");
        sb.append("  Instance group name : ").append(instanceGroupName).append("\n");
        sb.append("  Instance count      : ").append(instanceCount).append("\n");
        sb.append("  Instance template     ").append("\n");
        sb.append("     - Name           : ").append(instanceTemplate.getName()).append("\n");
        sb.append("     - Image          : ").append(instanceTemplate.getProperties().getDisks(0).getInitializeParams().getSourceImage()).append("\n");
        sb.append("     - Machine type   : ").append(instanceTemplate.getProperties().getMachineType()).append("\n");
        sb.append("\n");
        sb.append("Do you want to create a managed instance group with the above configuration?");
        if (ConsoleUiUtils.confirm(sb.toString())) {
            System.out.println();
            boolean appendRegionName = selectedRegions.size() > 1 && instanceCount > 1;
            int remainingRegions = selectedRegions.size();
            int remainingInstances = instanceCount;
            for (Region region : selectedRegions) {
                String regionName = region.getName();
                int instancesInRegion = (int)Math.ceil((double)remainingInstances / (double)remainingRegions);
                remainingInstances -= instancesInRegion;
                --remainingRegions;
                if (instancesInRegion <= 0) continue;
                try {
                    String regionizedInstanceGroupName = appendRegionName ? instanceGroupName + "-" + regionName : instanceGroupName;
                    System.out.printf("Creating instance group '%s' with %d instance(s) in region '%s' ... ", regionizedInstanceGroupName, instancesInRegion, regionName);
                    this.gceClient.createInstanceGroup(regionName, regionizedInstanceGroupName, instanceTemplate.getName(), instancesInRegion);
                    System.out.println("OK");
                }
                catch (Exception e) {
                    GceAdminUtils.logError("Failed to create instance group", e);
                }
            }
        }
    }

    private static String getRegionNames(List<Region> regions) {
        List regionNames = regions.stream().map(Region::getName).collect(Collectors.toList());
        return StringUtils.join(regionNames, (String)", ");
    }

    private InstanceTemplate selectInstanceTemplate(List<InstanceTemplate> instanceTemplates) {
        ArrayList<String> instanceTemplateNames = new ArrayList<String>();
        for (InstanceTemplate instanceTemplate : instanceTemplates) {
            instanceTemplateNames.add(instanceTemplate.getName());
        }
        return ConsoleUiUtils.selectItem("Select an instance template:", instanceTemplateNames, instanceTemplates);
    }

    private String readInstanceGroupName() {
        return ConsoleUiUtils.readLine("Enter the name of the instance group");
    }

    private int readInstanceCount() {
        return ConsoleUiUtils.readInt("Enter the number of instances to start");
    }
}

